/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.carpentry.BlockCarpentry;
import binnie.extratrees.carpentry.DesignBlock;
import binnie.extratrees.carpentry.ModuleCarpentry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentryPanel
extends BlockCarpentry {
    public BlockCarpentryPanel() {
        this.field_149783_u = true;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
        this.func_149713_g(0);
    }

    @Override
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        DesignBlock block = this.getCarpentryBlock(world, x, y, z);
        switch (block.getFacing()) {
            case DOWN: {
                this.func_149676_a(0.0f, 0.9375f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case EAST: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0625f, 1.0f, 1.0f);
                break;
            }
            case NORTH: {
                this.func_149676_a(0.0f, 0.0f, 0.9375f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0625f);
                break;
            }
            case UP: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
                break;
            }
            case WEST: {
                this.func_149676_a(0.9375f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    @Override
    public String getBlockName(ItemStack stack) {
        DesignBlock block = ModuleCarpentry.getDesignBlock(this.getDesignSystem(), TileEntityMetadata.getItemDamage(stack));
        return block.getDesign().getName() + " Wooden Panel";
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return AxisAlignedBB.func_72330_a((double)((double)par2 + this.field_149759_B), (double)((double)par3 + this.field_149760_C), (double)((double)par4 + this.field_149754_D), (double)((double)par2 + this.field_149755_E), (double)((double)par3 + this.field_149756_F), (double)((double)par4 + this.field_149757_G));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return super.func_149646_a(world, x, y, z, side);
    }

    @Override
    public DesignBlock getCarpentryBlock(IBlockAccess world, int x, int y, int z) {
        return ModuleCarpentry.getCarpentryPanel(this.getDesignSystem(), TileEntityMetadata.getTileMetadata(world, x, y, z));
    }

    public static boolean isValidPanelPlacement(World world, int x, int y, int z, ForgeDirection facing) {
        if (facing == ForgeDirection.UNKNOWN) {
            return false;
        }
        int bx = x - facing.offsetX;
        int by = y - facing.offsetY;
        int bz = z - facing.offsetZ;
        Block block = world.func_147439_a(bx, by, bz);
        if (block == null) {
            return false;
        }
        return block.isSideSolid((IBlockAccess)world, bx, by, bz, facing);
    }

    @Override
    public int getPlacedMeta(ItemStack item, World world, int x, int y, int z, ForgeDirection clickedBlock) {
        DesignBlock block = ModuleCarpentry.getCarpentryPanel(this.getDesignSystem(), TileEntityMetadata.getItemDamage(item));
        ForgeDirection facing = clickedBlock;
        boolean valid = true;
        if (!BlockCarpentryPanel.isValidPanelPlacement(world, x, y, z, facing)) {
            valid = false;
            for (ForgeDirection direction : ForgeDirection.values()) {
                if (!BlockCarpentryPanel.isValidPanelPlacement(world, x, y, z, direction)) continue;
                facing = direction;
                valid = true;
                break;
            }
        }
        if (!valid) {
            return -1;
        }
        block.setFacing(facing);
        return block.getBlockMetadata(this.getDesignSystem());
    }

    public void func_149695_a(World world, int x, int y, int z, Block par5) {
        super.func_149695_a(world, x, y, z, par5);
        DesignBlock block = this.getCarpentryBlock((IBlockAccess)world, x, y, z);
        if (!BlockCarpentryPanel.isValidPanelPlacement(world, x, y, z, block.getFacing())) {
            for (ItemStack stack : BlockCarpentryPanel.getBlockDropped(this, world, x, y, z, 0)) {
                this.func_149642_a(world, x, y, z, stack);
            }
            world.func_147468_f(x, y, z);
        }
    }
}

