/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.BinnieCore;
import binnie.core.IInitializable;
import binnie.core.Mods;
import binnie.core.block.ItemMetadata;
import binnie.core.block.ItemMetadataRenderer;
import binnie.core.block.TileEntityMetadata;
import binnie.core.liquid.ILiquidType;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.block.BlockETDoor;
import binnie.extratrees.block.BlockETLog;
import binnie.extratrees.block.BlockETPlanks;
import binnie.extratrees.block.BlockETSlab;
import binnie.extratrees.block.BlockETStairs;
import binnie.extratrees.block.BranchBlockRenderer;
import binnie.extratrees.block.DoorBlockRenderer;
import binnie.extratrees.block.DoorType;
import binnie.extratrees.block.GateItemRenderer;
import binnie.extratrees.block.ILogType;
import binnie.extratrees.block.IPlankType;
import binnie.extratrees.block.ItemETDoor;
import binnie.extratrees.block.ItemETSlab;
import binnie.extratrees.block.ItemETStairs;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.block.StairItemRenderer;
import binnie.extratrees.block.StairsRenderer;
import binnie.extratrees.block.WoodManager;
import binnie.extratrees.block.decor.BlockFence;
import binnie.extratrees.block.decor.BlockGate;
import binnie.extratrees.block.decor.BlockMultiFence;
import binnie.extratrees.block.decor.FenceRenderer;
import binnie.extratrees.block.decor.FenceType;
import binnie.extratrees.block.decor.HedgeRenderer;
import binnie.extratrees.block.decor.MultiFenceRecipeEmbedded;
import binnie.extratrees.block.decor.MultiFenceRecipeSize;
import binnie.extratrees.block.decor.MultiFenceRecipeSolid;
import binnie.extratrees.item.ExtraTreeLiquid;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.recipes.RecipeManagers;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModuleBlocks
implements IInitializable {
    public static int hedgeRenderID;

    @Override
    public void preInit() {
        PlankType.setup();
        ExtraTrees.blockPlanks = new BlockETPlanks();
        ExtraTrees.blockFence = new BlockFence();
        ExtraTrees.blockLog = new BlockETLog();
        ExtraTrees.blockGate = new BlockGate();
        ExtraTrees.blockDoor = new BlockETDoor();
        ExtraTrees.blockMultiFence = new BlockMultiFence();
        ExtraTrees.blockSlab = new BlockETSlab(false);
        ExtraTrees.blockDoubleSlab = new BlockETSlab(true);
        ExtraTrees.blockStairs = new BlockETStairs(ExtraTrees.blockPlanks);
        GameRegistry.registerBlock((Block)ExtraTrees.blockPlanks, ItemMetadata.class, (String)"planks");
        GameRegistry.registerBlock((Block)ExtraTrees.blockFence, ItemMetadata.class, (String)"fence");
        GameRegistry.registerBlock((Block)ExtraTrees.blockMultiFence, ItemMetadata.class, (String)"multifence");
        BinnieCore.proxy.registerCustomItemRenderer(Item.func_150898_a((Block)ExtraTrees.blockMultiFence), new ItemMetadataRenderer());
        GameRegistry.registerBlock((Block)ExtraTrees.blockLog, ItemMetadata.class, (String)"log");
        GameRegistry.registerBlock((Block)ExtraTrees.blockGate, ItemMetadata.class, (String)"gate");
        GameRegistry.registerBlock((Block)ExtraTrees.blockSlab, ItemETSlab.class, (String)"slab");
        GameRegistry.registerBlock((Block)ExtraTrees.blockDoubleSlab, ItemETSlab.class, (String)"doubleSlab");
        GameRegistry.registerBlock((Block)ExtraTrees.blockDoor, ItemETDoor.class, (String)"door");
        GameRegistry.registerBlock((Block)ExtraTrees.blockStairs, ItemETStairs.class, (String)"stairs");
        BinnieCore.proxy.registerCustomItemRenderer(Item.func_150898_a((Block)ExtraTrees.blockStairs), new StairItemRenderer());
        BinnieCore.proxy.registerCustomItemRenderer(Item.func_150898_a((Block)ExtraTrees.blockGate), new GateItemRenderer());
        for (ILogType.ExtraTreeLog extraTreeLog : ILogType.ExtraTreeLog.values()) {
            OreDictionary.registerOre((String)"logWood", (ItemStack)extraTreeLog.getItemStack());
        }
        GameRegistry.addSmelting((Block)ExtraTrees.blockLog, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        for (Enum enum_ : PlankType.ExtraTreePlanks.values()) {
            OreDictionary.registerOre((String)"plankWood", (ItemStack)enum_.getStack());
        }
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-fence-block", (String)"ExtraTrees:fence");
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-fence-block", (String)"ExtraTrees:gate");
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-alveary-slab", (String)"ExtraTrees:slab");
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-fence-block", (String)"ExtraTrees:multifence");
        hedgeRenderID = BinnieCore.proxy.getUniqueRenderID();
    }

    @Override
    public void init() {
        ExtraTrees.fenceID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new FenceRenderer());
        ExtraTrees.stairsID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new StairsRenderer());
        ExtraTrees.doorRenderId = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new DoorBlockRenderer());
        ExtraTrees.branchRenderId = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BranchBlockRenderer());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new HedgeRenderer());
        RecipeSorter.register((String)"extratrees:multifence", MultiFenceRecipeSize.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"extratrees:multifence2", MultiFenceRecipeEmbedded.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"extratrees:multifence3", MultiFenceRecipeSolid.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
    }

    @Override
    public void postInit() {
        for (PlankType.ExtraTreePlanks plank : PlankType.ExtraTreePlanks.values()) {
            ItemStack planks = plank.getStack();
            ItemStack slabs = TileEntityMetadata.getItemStack(ExtraTrees.blockSlab, plank.ordinal());
            ItemStack stairs = TileEntityMetadata.getItemStack(ExtraTrees.blockStairs, plank.ordinal());
            stairs.field_77994_a = 4;
            GameRegistry.addRecipe((ItemStack)stairs.func_77946_l(), (Object[])new Object[]{"#  ", "## ", "###", Character.valueOf('#'), planks.func_77946_l()});
            slabs.field_77994_a = 6;
            CraftingManager.func_77594_a().func_77592_b().add(0, new ShapedOreRecipe(slabs.func_77946_l(), new Object[]{"###", Character.valueOf('#'), planks.func_77946_l()}));
        }
        GameRegistry.addRecipe((IRecipe)new MultiFenceRecipeSize());
        GameRegistry.addRecipe((IRecipe)new MultiFenceRecipeEmbedded());
        GameRegistry.addRecipe((IRecipe)new MultiFenceRecipeSolid());
        for (IPlankType plank : WoodManager.getAllPlankTypes()) {
            ItemStack planks = plank.getStack();
            ItemStack fenceNormal = WoodManager.getFence(plank, new FenceType(0), 1);
            ItemStack gate = WoodManager.getGate(plank);
            ItemStack doorStandard = WoodManager.getDoor(plank, DoorType.Standard);
            ItemStack doorSolid = WoodManager.getDoor(plank, DoorType.Solid);
            ItemStack doorSplit = WoodManager.getDoor(plank, DoorType.Double);
            ItemStack doorFull = WoodManager.getDoor(plank, DoorType.Full);
            if (planks == null || gate == null) continue;
            gate.field_77994_a = 1;
            GameRegistry.addRecipe((ItemStack)gate.func_77946_l(), (Object[])new Object[]{"#p#", "#p#", Character.valueOf('#'), Items.field_151055_y, Character.valueOf('p'), planks.func_77946_l()});
            fenceNormal.field_77994_a = 4;
            GameRegistry.addRecipe((ItemStack)fenceNormal.func_77946_l(), (Object[])new Object[]{"###", "# #", Character.valueOf('#'), planks.func_77946_l()});
            GameRegistry.addRecipe((ItemStack)doorSolid.func_77946_l(), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), planks.func_77946_l()});
            GameRegistry.addRecipe((ItemStack)doorStandard.func_77946_l(), (Object[])new Object[]{"# #", "###", "###", Character.valueOf('#'), planks.func_77946_l()});
            GameRegistry.addRecipe((ItemStack)doorSplit.func_77946_l(), (Object[])new Object[]{"# #", "###", "# #", Character.valueOf('#'), planks.func_77946_l()});
            GameRegistry.addRecipe((ItemStack)doorFull.func_77946_l(), (Object[])new Object[]{"# #", "# #", "# #", Character.valueOf('#'), planks.func_77946_l()});
        }
        this.addSqueezer(ILogType.VanillaLog.Spruce, ExtraTreeLiquid.Resin, 50);
    }

    public void addSqueezer(ILogType log, ILiquidType liquid, int amount, float pulpChance) {
        FluidStack liquidStack = liquid.get(amount);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{log.getItemStack()}, liquidStack, Mods.Forestry.stack("woodPulp"), (int)(100.0f * pulpChance));
    }

    public void addSqueezer(ILogType log, ILiquidType liquid, int amount) {
        this.addSqueezer(log, liquid, amount, 0.5f);
    }
}

