/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.block.BlockMetadata;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.block.DoorType;
import binnie.extratrees.block.IPlankType;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.block.WoodManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockETDoor
extends BlockDoor
implements IBlockMetadata {
    private IIcon getFlippedIcon(boolean upper, boolean flip, int tileMeta) {
        DoorType type = BlockETDoor.getDoorType(tileMeta);
        return upper ? (flip ? type.iconDoorUpperFlip : type.iconDoorUpper) : (flip ? type.iconDoorLowerFlip : type.iconDoorLower);
    }

    public static DoorType getDoorType(int tileMeta) {
        int type = (tileMeta & 0xF00) >> 8;
        if (type >= 0 && type < DoorType.values().length) {
            return DoorType.values()[type];
        }
        return DoorType.Standard;
    }

    protected BlockETDoor() {
        super(Material.field_151575_d);
        this.func_149711_c(3.0f).func_149672_a(field_149766_f);
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_149663_c("door");
    }

    public IIcon func_149691_a(int side, int meta) {
        return DoorType.Standard.iconDoorLower;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        if (par5 != 1 && par5 != 0) {
            boolean flag2;
            int i1 = this.getFullMetadata(par1IBlockAccess, par2, par3, par4);
            int j1 = i1 & 3;
            boolean flag = (i1 & 4) != 0;
            boolean flag1 = false;
            boolean bl = flag2 = (i1 & 8) != 0;
            if (flag) {
                if (j1 == 0 && par5 == 2) {
                    flag1 = !flag1;
                } else if (j1 == 1 && par5 == 5) {
                    flag1 = !flag1;
                } else if (j1 == 2 && par5 == 3) {
                    flag1 = !flag1;
                } else if (j1 == 3 && par5 == 4) {
                    flag1 = !flag1;
                }
            } else {
                if (j1 == 0 && par5 == 5) {
                    flag1 = !flag1;
                } else if (j1 == 1 && par5 == 3) {
                    flag1 = !flag1;
                } else if (j1 == 2 && par5 == 4) {
                    flag1 = !flag1;
                } else if (j1 == 3 && par5 == 2) {
                    boolean bl2 = flag1 = !flag1;
                }
                if ((i1 & 0x10) != 0) {
                    flag1 = !flag1;
                }
            }
            int tileMeta = 0;
            tileMeta = flag2 ? TileEntityMetadata.getTileMetadata(par1IBlockAccess, par2, par3 - 1, par4) : TileEntityMetadata.getTileMetadata(par1IBlockAccess, par2, par3, par4);
            return this.getFlippedIcon(flag2, flag1, tileMeta);
        }
        return DoorType.Standard.iconDoorLower;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (DoorType type : DoorType.values()) {
            type.iconDoorLower = ExtraTrees.proxy.getIcon(register, "door." + type.iconName + ".lower");
            type.iconDoorUpper = ExtraTrees.proxy.getIcon(register, "door." + type.iconName + ".upper");
            type.iconDoorLowerFlip = new IconFlipped(type.iconDoorLower, true, false);
            type.iconDoorUpperFlip = new IconFlipped(type.iconDoorUpper, true, false);
        }
    }

    public int func_149645_b() {
        return ExtraTrees.doorRenderId;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        boolean flag2;
        int par5 = 2;
        int i1 = this.getFullMetadata(par1IBlockAccess, par2, par3, par4);
        int j1 = i1 & 3;
        boolean flag = (i1 & 4) != 0;
        boolean flag1 = false;
        boolean bl = flag2 = (i1 & 8) != 0;
        if (flag) {
            if (j1 == 0 && par5 == 2) {
                flag1 = !flag1;
            } else if (j1 == 1 && par5 == 5) {
                flag1 = !flag1;
            } else if (j1 == 2 && par5 == 3) {
                flag1 = !flag1;
            } else if (j1 == 3 && par5 == 4) {
                flag1 = !flag1;
            }
        } else {
            if (j1 == 0 && par5 == 5) {
                flag1 = !flag1;
            } else if (j1 == 1 && par5 == 3) {
                flag1 = !flag1;
            } else if (j1 == 2 && par5 == 4) {
                flag1 = !flag1;
            } else if (j1 == 3 && par5 == 2) {
                boolean bl2 = flag1 = !flag1;
            }
            if ((i1 & 0x10) != 0) {
                boolean bl3 = flag1 = !flag1;
            }
        }
        if (flag2) {
            int meta = TileEntityMetadata.getTileMetadata(par1IBlockAccess, par2, par3 - 1, par4);
            return WoodManager.getPlankType(meta & 0xFF).getColour();
        }
        int meta = TileEntityMetadata.getTileMetadata(par1IBlockAccess, par2, par3, par4);
        return WoodManager.getPlankType(meta & 0xFF).getColour();
    }

    public int getFullMetadata(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int j1;
        int i1;
        boolean flag;
        int l = par1IBlockAccess.func_72805_g(par2, par3, par4);
        boolean bl = flag = (l & 8) != 0;
        if (flag) {
            i1 = par1IBlockAccess.func_72805_g(par2, par3 - 1, par4);
            j1 = l;
        } else {
            i1 = l;
            j1 = par1IBlockAccess.func_72805_g(par2, par3 + 1, par4);
        }
        boolean flag1 = (j1 & 1) != 0;
        return i1 & 7 | (flag ? 8 : 0) | (flag1 ? 16 : 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149681_a(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
        if (par6EntityPlayer.field_71075_bZ.field_75098_d && (par5 & 8) != 0 && par1World.func_147439_a(par2, par3 - 1, par4) == this) {
            par1World.func_147468_f(par2, par3 - 1, par4);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int blockMeta, int fortune) {
        return BlockMetadata.getBlockDropped(this, world, x, y, z, blockMeta);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return BlockMetadata.breakBlock(this, player, world, x, y, z);
    }

    public TileEntity func_149915_a(World var1, int k) {
        return new TileEntityMetadata();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public boolean func_149696_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        super.func_149696_a(par1World, par2, par3, par4, par5, par6);
        TileEntity tileentity = par1World.func_147438_o(par2, par3, par4);
        return tileentity != null ? tileentity.func_145842_c(par5, par6) : false;
    }

    @Override
    public int getPlacedMeta(ItemStack stack, World world, int x, int y, int z, ForgeDirection clickedBlock) {
        return TileEntityMetadata.getItemDamage(stack);
    }

    @Override
    public int getDroppedMeta(int blockMeta, int tileMeta) {
        return tileMeta;
    }

    @Override
    public String getBlockName(ItemStack par1ItemStack) {
        int meta = TileEntityMetadata.getItemDamage(par1ItemStack);
        DoorType type = BlockETDoor.getDoorType(meta);
        return type.name + WoodManager.getPlankType(meta & 0xFF).getName() + " Wood Door";
    }

    @Override
    public void getBlockTooltip(ItemStack par1ItemStack, List par3List) {
    }

    @Override
    public void dropAsStack(World world, int x, int y, int z, ItemStack drop) {
        this.func_149642_a(world, x, y, z, drop);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (PlankType.ExtraTreePlanks extraTreePlanks : PlankType.ExtraTreePlanks.values()) {
            itemList.add(WoodManager.getDoor(extraTreePlanks, DoorType.Standard));
        }
        for (Enum enum_ : PlankType.ForestryPlanks.values()) {
            itemList.add(WoodManager.getDoor((IPlankType)((Object)enum_), DoorType.Standard));
        }
        for (Enum enum_ : PlankType.ExtraBiomesPlank.values()) {
            if (enum_.getStack() == null) continue;
            itemList.add(WoodManager.getDoor((IPlankType)((Object)enum_), DoorType.Standard));
        }
        for (Enum enum_ : PlankType.VanillaPlanks.values()) {
            itemList.add(WoodManager.getDoor((IPlankType)((Object)enum_), DoorType.Standard));
        }
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 5;
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        super.func_149749_a(par1World, par2, par3, par4, par5, par6);
        par1World.func_147475_p(par2, par3, par4);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return BlockMetadata.getPickBlock(world, x, y, z);
    }
}

