/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol.drink;

import binnie.extratrees.alcohol.Alcohol;
import binnie.extratrees.alcohol.Glassware;
import binnie.extratrees.alcohol.drink.DrinkManager;
import binnie.extratrees.alcohol.drink.IDrinkLiquid;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemDrink
extends ItemFood
implements IFluidContainerItem {
    public ItemDrink() {
        super(0, 0.0f, false);
        this.func_77637_a(Tabs.tabArboriculture);
        this.func_77655_b("drink");
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77848_i();
    }

    public Glassware getGlassware(ItemStack container) {
        if (!container.func_77942_o() || !container.func_77978_p().func_74764_b("Glassware")) {
            return Glassware.BeerMug;
        }
        return Glassware.values()[container.func_77978_p().func_74765_d("Glassware")];
    }

    public ItemStack getStack(Glassware glass, FluidStack fluid) {
        ItemStack stack = new ItemStack((Item)this);
        this.saveGlassware(glass, stack);
        this.saveFluid(fluid, stack);
        return stack;
    }

    public void saveGlassware(Glassware container, ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74777_a("Glassware", (short)container.ordinal());
    }

    public void saveFluid(FluidStack fluid, ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (fluid == null) {
            nbt.func_82580_o("Fluid");
        } else {
            NBTTagCompound liq = new NBTTagCompound();
            fluid.writeToNBT(liq);
            nbt.func_74782_a("Fluid", (NBTBase)liq);
        }
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
    }

    public int getCapacity(ItemStack container) {
        return this.getGlassware(container).getCapacity();
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null || !container.func_77942_o()) {
            return 0;
        }
        if (DrinkManager.getLiquid(resource.getFluid()) == null) {
            return 0;
        }
        FluidStack existing = this.getFluid(container);
        int space = this.getGlassware(container).getCapacity() - (existing == null ? 0 : existing.amount);
        int added = Math.min(space, resource.amount);
        if (space <= 0) {
            return 0;
        }
        if (existing != null) {
            if (!existing.isFluidEqual(resource)) {
                return 0;
            }
            if (doFill) {
                FluidStack fill = existing.copy();
                fill.amount += added;
                this.saveFluid(fill, container);
            }
            return added;
        }
        if (doFill) {
            FluidStack fill = resource.copy();
            fill.amount = added;
            this.saveFluid(fill, container);
        }
        return added;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (!container.func_77942_o()) {
            return null;
        }
        FluidStack content = this.getFluid(container);
        if (content == null) {
            return null;
        }
        int toRemove = Math.min(maxDrain, content.amount);
        FluidStack fill = content.copy();
        FluidStack drain = content.copy();
        drain.amount = toRemove;
        fill.amount -= toRemove;
        if (fill.amount == 0) {
            fill = null;
        }
        if (doDrain) {
            this.saveFluid(fill, container);
        }
        return drain;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (Glassware glassware : Glassware.values()) {
            par3List.add(this.getStack(glassware, null));
        }
        par3List.add(this.getStack(Glassware.Wine, Alcohol.RedWine.get(Glassware.Wine.getCapacity())));
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluid = this.getFluid(stack);
        IDrinkLiquid liquid = fluid == null ? null : DrinkManager.getLiquid(fluid.getFluid());
        return this.getGlassware(stack).getName(liquid == null ? null : liquid.getName());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        for (Glassware glassware : Glassware.values()) {
            glassware.registerIcons(par1IconRegister);
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        Glassware glass = this.getGlassware(stack);
        return pass == 0 ? glass.glass : (this.getFluid(stack) == null ? glass.glass : glass.contents);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        IDrinkLiquid drink;
        FluidStack fluid = this.getFluid(stack);
        IDrinkLiquid iDrinkLiquid = drink = fluid == null ? null : DrinkManager.getLiquid(fluid.getFluid());
        return pass == 0 ? 0xFFFFFF : (drink == null ? 0xFFFFFF : drink.getColour());
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    public ItemStack func_77654_b(ItemStack p_77654_1_, World p_77654_2_, EntityPlayer p_77654_3_) {
        this.drain(p_77654_1_, 30, true);
        return p_77654_1_;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return this.getFluid(p_77661_1_) == null ? EnumAction.none : EnumAction.drink;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 8;
    }

    public ItemStack func_77659_a(ItemStack p_77659_1_, World p_77659_2_, EntityPlayer p_77659_3_) {
        p_77659_3_.func_71008_a(p_77659_1_, this.func_77626_a(p_77659_1_));
        return p_77659_1_;
    }
}

