/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol.drink;

import binnie.extratrees.ExtraTrees;
import binnie.extratrees.alcohol.Glassware;
import binnie.extratrees.alcohol.drink.DrinkManager;
import binnie.extratrees.alcohol.drink.IDrinkLiquid;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class CocktailRenderer
implements IItemRenderer {
    private void renderCocktail(RenderBlocks renderBlocks, ItemStack item, float p, float q, float r) {
        RenderItem renderItem = new RenderItem();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Glassware glass = ExtraTrees.drink.getGlassware(item);
        FluidStack fluid = ExtraTrees.drink.getFluid(item);
        IDrinkLiquid drink = fluid == null ? null : DrinkManager.getLiquid(fluid.getFluid());
        this.setColor(0xFFFFFF, 0.8f);
        renderItem.func_94149_a(0, 0, glass.glass, 16, 16);
        if (drink != null) {
            this.setColor(drink.getColour(), 1.2f * drink.getTransparency() + 0.3f);
            IIcon icon = glass.contents;
            float amount = (float)fluid.amount / (float)glass.getVolume();
            float level = glass.getContentHeight() * (1.0f - amount);
            float gapAtTop = 1.0f - (glass.getContentBottom() + glass.getContentHeight());
            float x = 0.0f;
            float y = 16.0f * (gapAtTop + level);
            float w = 16.0f;
            float h = 16.0f - y;
            float minV = icon.func_94207_b((double)y);
            float maxV = icon.func_94207_b(16.0);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(x + 0.0f), (double)(y + h), (double)renderItem.field_77023_b, (double)icon.func_94209_e(), (double)maxV);
            tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)renderItem.field_77023_b, (double)icon.func_94212_f(), (double)maxV);
            tessellator.func_78374_a((double)(x + w), (double)(y + 0.0f), (double)renderItem.field_77023_b, (double)icon.func_94212_f(), (double)minV);
            tessellator.func_78374_a((double)(x + 0.0f), (double)(y + 0.0f), (double)renderItem.field_77023_b, (double)icon.func_94209_e(), (double)minV);
            tessellator.func_78381_a();
        }
        GL11.glDisable((int)3042);
    }

    private void setColor(int i1, float alpha) {
        float f = (float)(i1 >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i1 >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i1 & 0xFF) / 255.0f;
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)(alpha > 1.0f ? 1.0f : alpha));
    }

    private void renderFace(Tessellator tessellator, ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                tessellator.func_78377_a(0.0, 0.0, 0.0);
                tessellator.func_78377_a(0.0, 0.0, 1.0);
                tessellator.func_78377_a(1.0, 0.0, 1.0);
                tessellator.func_78377_a(1.0, 0.0, 0.0);
            }
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return false;
            }
            case EQUIPPED: {
                return false;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.renderCocktail((RenderBlocks)data[0], item, -0.5f, -0.5f, -0.5f);
                break;
            }
            case EQUIPPED: {
                this.renderCocktail((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
            case INVENTORY: {
                this.renderCocktail((RenderBlocks)data[0], item, -0.5f, -0.5f, -0.5f);
                break;
            }
        }
    }
}

