/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.IInitializable;
import binnie.core.liquid.IFluidType;
import binnie.core.liquid.ItemFluidContainer;
import binnie.core.resource.BinnieIcon;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.alcohol.Alcohol;
import binnie.extratrees.alcohol.Cocktail;
import binnie.extratrees.alcohol.ICocktailIngredient;
import binnie.extratrees.alcohol.Juice;
import binnie.extratrees.alcohol.Liqueur;
import binnie.extratrees.alcohol.Spirit;
import binnie.extratrees.alcohol.drink.CocktailRenderer;
import binnie.extratrees.alcohol.drink.DrinkLiquid;
import binnie.extratrees.alcohol.drink.DrinkManager;
import binnie.extratrees.alcohol.drink.ItemDrink;
import binnie.extratrees.machines.Brewery;
import binnie.extratrees.machines.Distillery;
import binnie.extratrees.machines.Press;
import forestry.api.recipes.RecipeManagers;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ModuleAlcohol
implements IInitializable {
    public static int drinkRendererID;
    public static BinnieIcon liquid;

    @Override
    public void preInit() {
        liquid = Binnie.Resource.getBlockIcon(ExtraTrees.instance, "liquids/liquid");
        drinkRendererID = BinnieCore.proxy.getUniqueRenderID();
        ExtraTrees.drink = new ItemDrink();
        BinnieCore.proxy.registerCustomItemRenderer((Item)ExtraTrees.drink, new CocktailRenderer());
        Binnie.Liquid.createLiquids(Juice.values(), ItemFluidContainer.LiquidJuice);
        Binnie.Liquid.createLiquids(Alcohol.values(), ItemFluidContainer.LiquidAlcohol);
        Binnie.Liquid.createLiquids(Spirit.values(), ItemFluidContainer.LiquidSpirit);
        Binnie.Liquid.createLiquids(Liqueur.values(), ItemFluidContainer.LiquidLiqueuer);
        for (Juice juice : Juice.values()) {
            Cocktail.registerIngredient(juice);
        }
        for (Enum enum_ : Alcohol.values()) {
            Cocktail.registerIngredient((ICocktailIngredient)((Object)enum_));
        }
        for (Enum enum_ : Spirit.values()) {
            Cocktail.registerIngredient((ICocktailIngredient)((Object)enum_));
        }
        for (Enum enum_ : Liqueur.values()) {
            Cocktail.registerIngredient((ICocktailIngredient)((Object)enum_));
        }
        DrinkManager.registerDrinkLiquid("water", new DrinkLiquid("Water", 0xCCCCFF, 0.1f, 0.0f));
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        for (Juice juice : Juice.values()) {
            String oreDict = juice.squeezing;
            for (ItemStack stack : OreDictionary.getOres((String)oreDict)) {
                for (Map.Entry entry : RecipeManagers.squeezerManager.getRecipes().entrySet()) {
                    try {
                        ItemStack input = (ItemStack)((Object[])entry.getKey())[0];
                        FluidStack output = (FluidStack)((Object[])entry.getValue())[1];
                        if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)input)) continue;
                        int amount = output.amount;
                        if (output.getFluid().getName() == "seedoil") {
                            amount *= 2;
                        }
                        Press.addRecipe(input, juice.get(amount));
                    }
                    catch (Exception e) {}
                }
            }
        }
        for (Enum enum_ : Alcohol.values()) {
            for (String fermentLiquid : ((Alcohol)enum_).fermentationLiquid) {
                FluidStack fluid = Binnie.Liquid.getLiquidStack(fermentLiquid, 5);
                if (fluid == null) continue;
                Brewery.addRecipe(fluid, ((Alcohol)enum_).get(5));
            }
        }
        Brewery.addBeerAndMashRecipes();
        this.addDistillery(Alcohol.Apple, Spirit.AppleBrandy, Spirit.AppleLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Pear, Spirit.PearBrandy, Spirit.PearLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Apricot, Spirit.ApricotBrandy, Spirit.ApricotLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Banana, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Cherry, Spirit.CherryBrandy, Spirit.CherryLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Elderberry, Spirit.ElderberryBrandy, Spirit.ElderberryLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Peach, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Plum, Spirit.PlumBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Carrot, Spirit.FruitBrandy, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.WhiteWine, Spirit.Brandy, Spirit.Brandy, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.RedWine, Spirit.Brandy, Spirit.Brandy, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.SparklingWine, Spirit.Brandy, Spirit.Brandy, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Agave, Spirit.Tequila, Spirit.Tequila, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Potato, Spirit.FruitBrandy, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Citrus, Spirit.CitrusBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Cranberry, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Pineapple, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Tomato, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Fruit, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Barley, Spirit.Whiskey, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Wheat, Spirit.WheatWhiskey, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Rye, Spirit.RyeWhiskey, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Corn, Spirit.CornWhiskey, Spirit.Vodka, Spirit.NeutralSpirit);
    }

    private void addDistillery(IFluidType source, IFluidType a, IFluidType b, IFluidType c) {
        Distillery.addRecipe(source.get(5), a.get(4), 0);
        Distillery.addRecipe(source.get(5), b.get(2), 1);
        Distillery.addRecipe(source.get(5), c.get(1), 2);
        Distillery.addRecipe(a.get(5), b.get(2), 0);
        Distillery.addRecipe(a.get(5), b.get(1), 1);
        Distillery.addRecipe(b.get(5), c.get(2), 0);
    }
}

