/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.extratrees.ExtraTrees;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum Glassware {
    BeerMug("Beer Mug", "Mug", 16, 10, 14),
    Pint("Pint Glass", "Pint", 20, 6, 20),
    Snifter("Snifter Glass", "Glass", 17, 14, 11),
    Flute("Flute Glass", "Glass", 6, 13, 15),
    Cocktail("Cocktail Glass", "Glass", 8, 20, 8),
    Cordial("Cordial Glass", "Glass", 2, 15, 7),
    Collins("Collins Glass", "Glass", 12, 8, 18),
    Highball("Highball Glass", "Glass", 8, 10, 14),
    Hurricane("Hurricane Glass", "Glass", 15, 10, 18),
    Margarita("Margarita Glass", "Glass", 12, 18, 9),
    OldFashioned("Old Fashioned Glass", "Glass", 8, 13, 8),
    Wine("Wine Glass", "Glass", 8, 17, 10),
    Shot("Shot Glass", "Shot", 1, 13, 7),
    Sherry("Sherry Glass", "Glass", 2, 17, 7),
    Coupe("Coupe Glass", "Glass", 6, 19, 8);

    private String name;
    private int capacity;
    private String desc;
    float contentBottom;
    float contentHeight;
    public IIcon glass;
    public IIcon contents;

    public String getTypeName() {
        return this.name;
    }

    public String getName(String liquid) {
        if (liquid == null) {
            return "Empty " + this.getTypeName();
        }
        return this.desc + " of " + liquid;
    }

    public int getCapacity() {
        return this.capacity;
    }

    private Glassware(String name, String desc, int capacity, int contentBottom, int contentHeight) {
        this.name = name;
        this.capacity = 30 * capacity;
        this.desc = desc;
        this.contentBottom = (float)contentBottom / 32.0f;
        this.contentHeight = (float)contentHeight / 32.0f;
    }

    public void registerIcons(IIconRegister par1IconRegister) {
        this.glass = ExtraTrees.proxy.getIcon(par1IconRegister, "glassware/" + this.toString().toLowerCase() + ".glass");
        this.contents = ExtraTrees.proxy.getIcon(par1IconRegister, "glassware/" + this.toString().toLowerCase() + ".contents");
    }

    public ItemStack get(int i) {
        return ExtraTrees.drink.getStack(this, null);
    }

    public float getContentBottom() {
        return this.contentBottom;
    }

    public float getContentHeight() {
        return this.contentHeight;
    }

    public int getVolume() {
        return this.getCapacity();
    }
}

