/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.Binnie;
import binnie.core.liquid.FluidContainer;
import binnie.core.liquid.IFluidType;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.alcohol.ICocktailLiquid;
import binnie.extratrees.alcohol.Juice;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;

public enum Alcohol implements IFluidType,
ICocktailLiquid
{
    Apple("Cider", "ciderApple", 16432700, 0.3, 0.05),
    Apricot("Apricot Wine", "wineApricot", 15781686, 0.3, 0.1),
    Banana("Banana Wine", "wineBanana", 14993485, 0.3, 0.1),
    Cherry("Cherry Wine", "wineCherry", 11207702, 0.3, 0.1),
    Elderberry("Elderberry Wine", "wineElderberry", 9764865, 0.3, 0.1),
    Peach("Peach Cider", "ciderPeach", 15361563, 0.3, 0.05),
    Pear("Pear Cider", "ciderPear", 15061095, 0.3, 0.05),
    Plum("Plum Wine", "winePlum", 12063752, 0.3, 0.1),
    Carrot("Carrot Wine", "wineCarrot", 16219394, 0.3, 0.1),
    WhiteWine("White Wine", "wineWhite", 15587989, 0.1, 0.1),
    RedWine("Red Wine", "wineRed", 7670539, 0.2, 0.1),
    SparklingWine("Sparkling Wine", "wineSparkling", 16709566, 0.1, 0.1),
    Agave("Agave Wine", "wineAgave", 13938276, 0.2, 0.1),
    Potato("Fermented Potatoes", "fermentedPotatoes", 12028240, 0.8, 0.1),
    Citrus("Citrus Wine", "wineCitrus", 0xFFFF00, 0.2, 0.1),
    Cranberry("Cranberry Wine", "wineCranberry", 11599874, 0.2, 0.1),
    Pineapple("Pineapple Wine", "winePineapple", 14724150, 0.2, 0.1),
    Tomato("Tomato Wine", "wineTomato", 12458521, 0.2, 0.1),
    Fruit("Fruit Wine", "juice", 16432700, 0.2, 0.1),
    Ale("Ale", "beerAle", 12991009, 0.7, 0.05),
    Lager("Lager", "beerLager", 15301637, 0.7, 0.05),
    WheatBeer("Wheat Beer", "beerWheat", 14380552, 0.7, 0.05),
    RyeBeer("Rye Beer", "beerRye", 10836007, 0.7, 0.05),
    CornBeer("Corn Beer", "beerCorn", 13411364, 0.7, 0.05),
    Stout("Stout", "beerStout", 5843201, 0.8, 0.05),
    Barley("Fermented Grain Mash", "mashGrain", 12991009, 0.9, 0.05),
    Wheat("Fermented Wheat Mash", "mashWheat", 12991009, 0.9, 0.05),
    Rye("Fermented Rye Mash", "mashRye", 10836007, 0.9, 0.05),
    Corn("Fermented Corn Mash", "mashCorn", 13411364, 0.9, 0.05);

    List<String> fermentationLiquid = new ArrayList<String>();
    String fermentationSolid = "";
    String name;
    String ident;
    IIcon icon;
    int colour;
    float transparency;
    float abv;

    private void setFementation(Juice juice) {
        this.fermentationLiquid.add(juice.getIdentifier());
    }

    private void setFementation(String oreDict) {
        this.fermentationSolid = oreDict;
    }

    private Alcohol(String name, String ident, int colour, double transparency, double abv) {
        this.name = name;
        this.ident = ident;
        this.colour = colour;
        this.transparency = (float)transparency;
        this.abv = (float)abv;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public void registerIcon(IIconRegister register) {
        this.icon = ExtraTrees.proxy.getIcon(register, "liquids/liquid");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIdentifier() {
        return "binnie." + this.ident;
    }

    @Override
    public int getColour() {
        return this.colour;
    }

    @Override
    public FluidStack get(int amount) {
        return Binnie.Liquid.getLiquidStack(this.getIdentifier(), amount);
    }

    @Override
    public int getTransparency() {
        return (int)(Math.min(1.0, (double)this.transparency + 0.3) * 255.0);
    }

    @Override
    public String getTooltip(int ratio) {
        return ratio + " Part" + (ratio > 1 ? "s " : " ") + this.getName();
    }

    @Override
    public boolean canPlaceIn(FluidContainer container) {
        return true;
    }

    @Override
    public boolean showInCreative(FluidContainer container) {
        return container == FluidContainer.Glass;
    }

    @Override
    public int getContainerColour() {
        return this.getColour();
    }

    @Override
    public float getABV() {
        return this.abv;
    }

    static {
        Apple.setFementation(Juice.Apple);
        Apricot.setFementation(Juice.Apricot);
        Banana.setFementation(Juice.Banana);
        Cherry.setFementation(Juice.Cherry);
        Elderberry.setFementation(Juice.Elderberry);
        Peach.setFementation(Juice.Peach);
        Pear.setFementation(Juice.Pear);
        Plum.setFementation(Juice.Plum);
        Carrot.setFementation(Juice.Carrot);
        WhiteWine.setFementation(Juice.WhiteGrape);
        RedWine.setFementation(Juice.RedGrape);
        Citrus.setFementation(Juice.Lemon);
        Citrus.setFementation(Juice.Lime);
        Citrus.setFementation(Juice.Orange);
        Citrus.setFementation(Juice.Grapefruit);
        Tomato.setFementation(Juice.Tomato);
        Cranberry.setFementation(Juice.Cranberry);
        Pineapple.setFementation(Juice.Pineapple);
        Potato.setFementation("cropPotato");
    }
}

