/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.gui.punnett;

import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.TextJustification;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.LinkedList;

public class ControlPunnett
extends Control {
    static int boxWidth = 80;
    static int boxHeight = 28;

    protected ControlPunnett(IWidget parent, float x, float y) {
        super(parent, x, y, boxWidth * 3, boxWidth * 3);
    }

    @Override
    public void onRenderBackground() {
        this.getRenderer().renderSolidArea(new Area(0.0f, boxHeight, boxWidth * 3, 1.0f), 0xAAAAAA);
        this.getRenderer().renderSolidArea(new Area((float)boxWidth / 2.0f, boxHeight * 2, (float)boxWidth * 2.5f, 1.0f), 0xAAAAAA);
        this.getRenderer().renderSolidArea(new Area(boxWidth, 0.0f, 1.0f, boxHeight * 3), 0xAAAAAA);
        this.getRenderer().renderSolidArea(new Area(boxWidth * 2, (float)boxHeight / 2.0f, 1.0f, (float)boxHeight * 2.5f), 0xAAAAAA);
    }

    public void setup(IChromosomeType chromosome, IIndividual ind1, IIndividual ind2, ISpeciesRoot root) {
        this.deleteAllChildren();
        if (chromosome == null || ind1 == null || ind2 == null || root == null) {
            return;
        }
        IAllele primary1 = ind1.getGenome().getActiveAllele(chromosome.ordinal());
        IAllele primary2 = ind2.getGenome().getActiveAllele(chromosome.ordinal());
        IAllele secondary1 = ind1.getGenome().getInactiveAllele(chromosome.ordinal());
        IAllele secondary2 = ind2.getGenome().getInactiveAllele(chromosome.ordinal());
        int x = 1;
        int y = 1;
        for (IAllele allele1 : new IAllele[]{primary1, secondary1}) {
            y = 1;
            for (IAllele allele2 : new IAllele[]{primary2, secondary2}) {
                LinkedList<IAllele> alleles = new LinkedList<IAllele>();
                if (allele1.isDominant() && !allele2.isDominant()) {
                    alleles.add(allele1);
                } else if (allele2.isDominant() && !allele1.isDominant()) {
                    alleles.add(allele2);
                } else {
                    alleles.add(allele1);
                    if (allele1 != allele2) {
                        alleles.add(allele2);
                    }
                }
                String text = "";
                for (IAllele allele : alleles) {
                    text = text + allele.getName() + ": " + 25.0f / (float)alleles.size() + "%\n";
                }
                new ControlText(this, new Area(x * boxWidth, boxHeight * y, boxWidth, boxHeight), text, TextJustification.TopCenter).setColour(0xAAAAAA);
                ++y;
            }
            ++x;
        }
        new ControlText(this, new Area(boxWidth, 0.0f, boxWidth, boxHeight), "\n" + primary1.getName(), TextJustification.TopCenter).setColour(0xAAAAAA);
        new ControlText(this, new Area(boxWidth * 2, 0.0f, boxWidth, boxHeight), "\n" + secondary1.getName(), TextJustification.TopCenter).setColour(0xAAAAAA);
        new ControlText(this, new Area(0.0f, boxHeight, boxWidth, boxHeight), primary2.getName(), TextJustification.TopCenter).setColour(0xAAAAAA);
        new ControlText(this, new Area(0.0f, boxHeight * 2, boxWidth, boxHeight), primary2.getName(), TextJustification.TopCenter).setColour(0xAAAAAA);
    }
}

