/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.Binnie;
import binnie.core.genetics.ForestryAllele;
import binnie.extrabees.genetics.ExtraBeesSpecies;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class ExtraBeeMutation
implements IBeeMutation {
    public static List<IBeeMutation> mutations = new ArrayList<IBeeMutation>();
    IAlleleBeeSpecies species0 = null;
    IAlleleBeeSpecies species1 = null;
    IAllele[] template = new IAllele[0];
    int chance = 80;

    public static void doInit() {
        IAlleleBeeSpecies[] vanilla = new IAlleleBeeSpecies[]{};
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Meadows.getAllele(), ForestryAllele.BeeSpecies.Modest.getAllele(), ExtraBeesSpecies.ARID, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ARID, ForestryAllele.BeeSpecies.Common.getAllele(), ExtraBeesSpecies.BARREN, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ARID, (IAlleleBeeSpecies)ExtraBeesSpecies.BARREN, ExtraBeesSpecies.DESOLATE, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.BARREN, ForestryAllele.BeeSpecies.Forest.getAllele(), ExtraBeesSpecies.GNAWING, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.DESOLATE, ForestryAllele.BeeSpecies.Modest.getAllele(), ExtraBeesSpecies.ROTTEN, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.DESOLATE, ForestryAllele.BeeSpecies.Frugal.getAllele(), ExtraBeesSpecies.BONE, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.DESOLATE, ForestryAllele.BeeSpecies.Austere.getAllele(), ExtraBeesSpecies.CREEPER, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.GNAWING, ForestryAllele.BeeSpecies.Common.getAllele(), ExtraBeesSpecies.DECOMPOSING, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ROCK, ForestryAllele.BeeSpecies.Diligent.getAllele(), ExtraBeesSpecies.STONE, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ROCK, (IAlleleBeeSpecies)ExtraBeesSpecies.STONE, ExtraBeesSpecies.GRANITE, 15);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Imperial.getAllele(), (IAlleleBeeSpecies)ExtraBeesSpecies.GRANITE, ExtraBeesSpecies.MINERAL, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.MINERAL, ForestryAllele.BeeSpecies.Meadows.getAllele(), ExtraBeesSpecies.IRON, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.MINERAL, ForestryAllele.BeeSpecies.Forest.getAllele(), ExtraBeesSpecies.COPPER, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.MINERAL, ForestryAllele.BeeSpecies.Marshy.getAllele(), ExtraBeesSpecies.TIN, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.MINERAL, ForestryAllele.BeeSpecies.Unweary.getAllele(), ExtraBeesSpecies.LEAD, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.TIN, ForestryAllele.BeeSpecies.Cultivated.getAllele(), ExtraBeesSpecies.ZINC, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.MINERAL, ForestryAllele.BeeSpecies.Unweary.getAllele(), ExtraBeesSpecies.NICKEL, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.MINERAL, ForestryAllele.BeeSpecies.Noble.getAllele(), ExtraBeesSpecies.TITANIUM, 3);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.MINERAL, ForestryAllele.BeeSpecies.Ended.getAllele(), ExtraBeesSpecies.TUNGSTATE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.IRON, ForestryAllele.BeeSpecies.Imperial.getAllele(), ExtraBeesSpecies.SILVER, 2);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.COPPER, ForestryAllele.BeeSpecies.Imperial.getAllele(), ExtraBeesSpecies.GOLD, 2);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.GOLD, (IAlleleBeeSpecies)ExtraBeesSpecies.SILVER, ExtraBeesSpecies.PLATINUM, 2);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.MINERAL, (IAlleleBeeSpecies)ExtraBeesSpecies.WATER, ExtraBeesSpecies.LAPIS, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.LAPIS, ForestryAllele.BeeSpecies.Noble.getAllele(), ExtraBeesSpecies.EMERALD, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.EMERALD, ForestryAllele.BeeSpecies.Austere.getAllele(), ExtraBeesSpecies.RUBY, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.EMERALD, (IAlleleBeeSpecies)ExtraBeesSpecies.OCEAN, ExtraBeesSpecies.SAPPHIRE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.LAPIS, ForestryAllele.BeeSpecies.Imperial.getAllele(), ExtraBeesSpecies.DIAMOND, 5);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Austere.getAllele(), (IAlleleBeeSpecies)ExtraBeesSpecies.ROCK, ExtraBeesSpecies.UNSTABLE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.UNSTABLE, (IAlleleBeeSpecies)ExtraBeesSpecies.IRON, ExtraBeesSpecies.NUCLEAR, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.NUCLEAR, (IAlleleBeeSpecies)ExtraBeesSpecies.GOLD, ExtraBeesSpecies.RADIOACTIVE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.NUCLEAR, (IAlleleBeeSpecies)ExtraBeesSpecies.GOLD, ExtraBeesSpecies.YELLORIUM, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.NUCLEAR, (IAlleleBeeSpecies)ExtraBeesSpecies.YELLORIUM, ExtraBeesSpecies.CYANITE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.YELLORIUM, (IAlleleBeeSpecies)ExtraBeesSpecies.CYANITE, ExtraBeesSpecies.BLUTONIUM, 5);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Noble.getAllele(), ForestryAllele.BeeSpecies.Diligent.getAllele(), ExtraBeesSpecies.ANCIENT, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ANCIENT, ForestryAllele.BeeSpecies.Noble.getAllele(), ExtraBeesSpecies.PRIMEVAL, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.PRIMEVAL, ForestryAllele.BeeSpecies.Majestic.getAllele(), ExtraBeesSpecies.PREHISTORIC, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.PREHISTORIC, ForestryAllele.BeeSpecies.Imperial.getAllele(), ExtraBeesSpecies.RELIC, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.PRIMEVAL, (IAlleleBeeSpecies)ExtraBeesSpecies.GROWING, ExtraBeesSpecies.COAL, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.PRIMEVAL, (IAlleleBeeSpecies)ExtraBeesSpecies.FUNGAL, ExtraBeesSpecies.RESIN, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.PRIMEVAL, (IAlleleBeeSpecies)ExtraBeesSpecies.OCEAN, ExtraBeesSpecies.OIL, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.OIL, ForestryAllele.BeeSpecies.Industrious.getAllele(), ExtraBeesSpecies.DISTILLED, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.OIL, (IAlleleBeeSpecies)ExtraBeesSpecies.DISTILLED, ExtraBeesSpecies.FUEL, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.FUEL, (IAlleleBeeSpecies)ExtraBeesSpecies.COAL, ExtraBeesSpecies.CREOSOTE, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.FUEL, (IAlleleBeeSpecies)ExtraBeesSpecies.RESIN, ExtraBeesSpecies.LATEX, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.WATER, ForestryAllele.BeeSpecies.Common.getAllele(), ExtraBeesSpecies.RIVER, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.WATER, ForestryAllele.BeeSpecies.Diligent.getAllele(), ExtraBeesSpecies.OCEAN, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.BLACK, (IAlleleBeeSpecies)ExtraBeesSpecies.OCEAN, ExtraBeesSpecies.INK, 8);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Diligent.getAllele(), ForestryAllele.BeeSpecies.Forest.getAllele(), ExtraBeesSpecies.GROWING, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.GROWING, ForestryAllele.BeeSpecies.Rural.getAllele(), ExtraBeesSpecies.THRIVING, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.THRIVING, (IAlleleBeeSpecies)ExtraBeesSpecies.GROWING, ExtraBeesSpecies.BLOOMING, 8);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Valiant.getAllele(), ForestryAllele.BeeSpecies.Diligent.getAllele(), ExtraBeesSpecies.SWEET, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.SWEET, ForestryAllele.BeeSpecies.Diligent.getAllele(), ExtraBeesSpecies.SUGAR, 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.SUGAR, ForestryAllele.BeeSpecies.Forest.getAllele(), ExtraBeesSpecies.RIPENING, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.RIPENING, ForestryAllele.BeeSpecies.Rural.getAllele(), ExtraBeesSpecies.FRUIT, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.FRUIT, ForestryAllele.BeeSpecies.Rural.getAllele(), ExtraBeesSpecies.ALCOHOL, 10);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Cultivated.getAllele(), ForestryAllele.BeeSpecies.Rural.getAllele(), ExtraBeesSpecies.FARM, 10);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Rural.getAllele(), (IAlleleBeeSpecies)ExtraBeesSpecies.WATER, ExtraBeesSpecies.MILK, 10);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Tropical.getAllele(), ForestryAllele.BeeSpecies.Rural.getAllele(), ExtraBeesSpecies.COFFEE, 10);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Common.getAllele(), ForestryAllele.BeeSpecies.Marshy.getAllele(), ExtraBeesSpecies.SWAMP, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.SWAMP, ForestryAllele.BeeSpecies.Marshy.getAllele(), ExtraBeesSpecies.BOGGY, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.BOGGY, (IAlleleBeeSpecies)ExtraBeesSpecies.SWAMP, ExtraBeesSpecies.FUNGAL, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.WATER, ForestryAllele.BeeSpecies.Forest.getAllele(), ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.WATER, ForestryAllele.BeeSpecies.Meadows.getAllele(), ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.WATER, ForestryAllele.BeeSpecies.Modest.getAllele(), ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.WATER, ForestryAllele.BeeSpecies.Tropical.getAllele(), ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.WATER, ForestryAllele.BeeSpecies.Marshy.getAllele(), ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.WATER, ForestryAllele.BeeSpecies.Wintry.getAllele(), ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.WATER, (IAlleleBeeSpecies)ExtraBeesSpecies.ROCK, ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.WATER, (IAlleleBeeSpecies)ExtraBeesSpecies.BASALT, ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ROCK, ForestryAllele.BeeSpecies.Forest.getAllele(), ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ROCK, ForestryAllele.BeeSpecies.Meadows.getAllele(), ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ROCK, ForestryAllele.BeeSpecies.Modest.getAllele(), ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ROCK, ForestryAllele.BeeSpecies.Tropical.getAllele(), ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ROCK, ForestryAllele.BeeSpecies.Marshy.getAllele(), ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ROCK, ForestryAllele.BeeSpecies.Wintry.getAllele(), ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ROCK, (IAlleleBeeSpecies)ExtraBeesSpecies.BASALT, ForestryAllele.BeeSpecies.Common.getTemplate(), 15);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.WATER, ForestryAllele.BeeSpecies.Common.getAllele(), ForestryAllele.BeeSpecies.Cultivated.getTemplate(), 12);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ROCK, ForestryAllele.BeeSpecies.Common.getAllele(), ForestryAllele.BeeSpecies.Cultivated.getTemplate(), 12);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.BASALT, ForestryAllele.BeeSpecies.Sinister.getAllele(), ExtraBeesSpecies.TEMPERED, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.BASALT, (IAlleleBeeSpecies)ExtraBeesSpecies.TEMPERED, ExtraBeesSpecies.VOLCANIC, 6);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Sinister.getAllele(), ForestryAllele.BeeSpecies.Tropical.getAllele(), ExtraBeesSpecies.MALICIOUS, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.MALICIOUS, ForestryAllele.BeeSpecies.Tropical.getAllele(), ExtraBeesSpecies.INFECTIOUS, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.MALICIOUS, (IAlleleBeeSpecies)ExtraBeesSpecies.INFECTIOUS, ExtraBeesSpecies.VIRULENT, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.WATER, ForestryAllele.BeeSpecies.Exotic.getAllele(), ExtraBeesSpecies.VISCOUS, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.VISCOUS, ForestryAllele.BeeSpecies.Exotic.getAllele(), ExtraBeesSpecies.GLUTINOUS, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.VISCOUS, (IAlleleBeeSpecies)ExtraBeesSpecies.GLUTINOUS, ExtraBeesSpecies.STICKY, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.VIRULENT, (IAlleleBeeSpecies)ExtraBeesSpecies.STICKY, ExtraBeesSpecies.CORROSIVE, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.CORROSIVE, ForestryAllele.BeeSpecies.Fiendish.getAllele(), ExtraBeesSpecies.CAUSTIC, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.CORROSIVE, (IAlleleBeeSpecies)ExtraBeesSpecies.CAUSTIC, ExtraBeesSpecies.ACIDIC, 4);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Cultivated.getAllele(), ForestryAllele.BeeSpecies.Valiant.getAllele(), ExtraBeesSpecies.EXCITED, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.EXCITED, ForestryAllele.BeeSpecies.Valiant.getAllele(), ExtraBeesSpecies.ENERGETIC, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.EXCITED, (IAlleleBeeSpecies)ExtraBeesSpecies.ENERGETIC, ExtraBeesSpecies.ECSTATIC, 8);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Wintry.getAllele(), ForestryAllele.BeeSpecies.Diligent.getAllele(), ExtraBeesSpecies.ARTIC, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.OCEAN, (IAlleleBeeSpecies)ExtraBeesSpecies.ARTIC, ExtraBeesSpecies.FREEZING, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.STONE, ForestryAllele.BeeSpecies.Sinister.getAllele(), ExtraBeesSpecies.SHADOW, 10);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.SHADOW, (IAlleleBeeSpecies)ExtraBeesSpecies.BASALT, ExtraBeesSpecies.DARKENED, 8);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.SHADOW, (IAlleleBeeSpecies)ExtraBeesSpecies.DARKENED, ExtraBeesSpecies.ABYSS, 8);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Forest.getAllele(), ForestryAllele.BeeSpecies.Valiant.getAllele(), ExtraBeesSpecies.RED, 5);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Meadows.getAllele(), ForestryAllele.BeeSpecies.Valiant.getAllele(), ExtraBeesSpecies.YELLOW, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.WATER, ForestryAllele.BeeSpecies.Valiant.getAllele(), ExtraBeesSpecies.BLUE, 5);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Tropical.getAllele(), ForestryAllele.BeeSpecies.Valiant.getAllele(), ExtraBeesSpecies.GREEN, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.ROCK, ForestryAllele.BeeSpecies.Valiant.getAllele(), ExtraBeesSpecies.BLACK, 5);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Wintry.getAllele(), ForestryAllele.BeeSpecies.Valiant.getAllele(), ExtraBeesSpecies.WHITE, 5);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Marshy.getAllele(), ForestryAllele.BeeSpecies.Valiant.getAllele(), ExtraBeesSpecies.BROWN, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.RED, (IAlleleBeeSpecies)ExtraBeesSpecies.YELLOW, ExtraBeesSpecies.ORANGE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.GREEN, (IAlleleBeeSpecies)ExtraBeesSpecies.BLUE, ExtraBeesSpecies.CYAN, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.RED, (IAlleleBeeSpecies)ExtraBeesSpecies.BLUE, ExtraBeesSpecies.PURPLE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.BLACK, (IAlleleBeeSpecies)ExtraBeesSpecies.WHITE, ExtraBeesSpecies.GRAY, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.BLUE, (IAlleleBeeSpecies)ExtraBeesSpecies.WHITE, ExtraBeesSpecies.LIGHTBLUE, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.RED, (IAlleleBeeSpecies)ExtraBeesSpecies.WHITE, ExtraBeesSpecies.PINK, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.GREEN, (IAlleleBeeSpecies)ExtraBeesSpecies.WHITE, ExtraBeesSpecies.LIMEGREEN, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.PURPLE, (IAlleleBeeSpecies)ExtraBeesSpecies.PINK, ExtraBeesSpecies.MAGENTA, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.GRAY, (IAlleleBeeSpecies)ExtraBeesSpecies.WHITE, ExtraBeesSpecies.LIGHTGRAY, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.TEMPERED, (IAlleleBeeSpecies)ExtraBeesSpecies.EXCITED, ExtraBeesSpecies.GLOWSTONE, 5);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Austere.getAllele(), (IAlleleBeeSpecies)ExtraBeesSpecies.DESOLATE, ExtraBeesSpecies.HAZARDOUS, 5);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Ended.getAllele(), (IAlleleBeeSpecies)ExtraBeesSpecies.RELIC, ExtraBeesSpecies.JADED, 2);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Austere.getAllele(), (IAlleleBeeSpecies)ExtraBeesSpecies.EXCITED, ExtraBeesSpecies.CELEBRATORY, 5);
        new ExtraBeeMutation(ForestryAllele.BeeSpecies.Secluded.getAllele(), ForestryAllele.BeeSpecies.Ended.getAllele(), ExtraBeesSpecies.UNUSUAL, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.UNUSUAL, ForestryAllele.BeeSpecies.Hermitic.getAllele(), ExtraBeesSpecies.SPATIAL, 5);
        new ExtraBeeMutation((IAlleleBeeSpecies)ExtraBeesSpecies.SPATIAL, ForestryAllele.BeeSpecies.Spectral.getAllele(), ExtraBeesSpecies.QUANTUM, 5);
        for (IBeeMutation mutation : mutations) {
            Binnie.Genetics.getBeeRoot().registerMutation((IMutation)mutation);
        }
    }

    public ExtraBeeMutation(IAlleleBeeSpecies allele0, IAlleleBeeSpecies allele1, ExtraBeesSpecies mutation, int chance) {
        this(allele0, allele1, mutation.getTemplate(), chance);
    }

    public ExtraBeeMutation(IAlleleBeeSpecies allele0, IAlleleBeeSpecies allele1, IAllele[] mutation, int chance) {
        this.chance = chance;
        this.species0 = allele0;
        this.species1 = allele1;
        this.template = mutation;
        if (this.species0 != null && this.species1 != null && this.template != null) {
            mutations.add(this);
        }
    }

    public IAllele getAllele0() {
        return this.species0;
    }

    public IAllele getAllele1() {
        return this.species1;
    }

    public IAllele[] getTemplate() {
        return this.template;
    }

    public float getBaseChance() {
        return this.chance;
    }

    public boolean isPartner(IAllele allele) {
        return allele.getUID().equals(this.species0.getUID()) || allele.getUID().equals(this.species1.getUID());
    }

    public IAllele getPartner(IAllele allele) {
        return allele.getUID().equals(this.species0.getUID()) ? this.species1 : this.species0;
    }

    public boolean isSecret() {
        return false;
    }

    public float getChance(IBeeHousing housing, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        if (this.species0 == null || this.species1 == null || allele0 == null || allele1 == null) {
            return 0.0f;
        }
        World world = housing.getWorld();
        int x = housing.getXCoord();
        int y = housing.getYCoord();
        int z = housing.getZCoord();
        int biome = housing.getBiomeId();
        if (!(this.template[0] != ExtraBeesSpecies.JADED || housing.getOwnerName() != null && housing.getOwnerName().equals((Object)"jadedcat"))) {
            return 0.0f;
        }
        if (this.template[0] == ExtraBeesSpecies.OCEAN && BiomeGenBase.func_150568_d((int)biome) != BiomeGenBase.field_76771_b) {
            return 0.0f;
        }
        int processedChance = Math.round((float)this.chance * housing.getMutationModifier((IBeeGenome)genome0, (IBeeGenome)genome1, 1.0f) * Binnie.Genetics.getBeeRoot().getBeekeepingMode(world).getMutationModifier((IBeeGenome)genome0, (IBeeGenome)genome1, 1.0f));
        if (this.species0.getUID().equals(allele0.getUID()) && this.species1.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        if (this.species1.getUID().equals(allele0.getUID()) && this.species0.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        return 0.0f;
    }

    public Collection<String> getSpecialConditions() {
        ArrayList<String> conditions = new ArrayList<String>();
        if (this.getTemplate()[0] == ExtraBeesSpecies.OCEAN) {
            conditions.add("Hive needs to be in Ocean");
        }
        return conditions;
    }

    public IBeeRoot getRoot() {
        return Binnie.Genetics.getBeeRoot();
    }
}

