/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.resource.minecraft;

import binnie.core.resource.BinnieResource;
import binnie.core.resource.IBinnieTexture;
import binnie.craftgui.core.geometry.Direction;
import binnie.craftgui.resource.ITexture;
import binnie.craftgui.resource.ITexturePadded;
import binnie.craftgui.resource.minecraft.StandardTexture;

public class PaddedTexture
extends StandardTexture
implements ITexturePadded {
    int leftPadding;
    int rightPadding;
    int topPadding;
    int bottomPadding;

    public PaddedTexture(int u, int v, int w, int h, int offset, IBinnieTexture textureFile, int leftPadding, int rightPadding, int topPadding, int bottomPadding) {
        this(u, v, w, h, offset, textureFile.getTexture(), leftPadding, rightPadding, topPadding, bottomPadding);
    }

    public PaddedTexture(int u, int v, int w, int h, int offset, BinnieResource textureFile, int leftPadding, int rightPadding, int topPadding, int bottomPadding) {
        super(u, v, w, h, offset, textureFile);
        this.leftPadding = leftPadding;
        this.rightPadding = rightPadding;
        this.topPadding = topPadding;
        this.bottomPadding = bottomPadding;
    }

    @Override
    public int l() {
        return this.leftPadding;
    }

    @Override
    public int r() {
        return this.rightPadding;
    }

    @Override
    public int t() {
        return this.topPadding;
    }

    @Override
    public int b() {
        return this.bottomPadding;
    }

    @Override
    public ITexture subTexture(Direction direction, int distance) {
        switch (direction) {
            case Downwards: {
                return new PaddedTexture(this.u(), this.v(), this.w, distance, 0, this.textureFile, this.l(), this.r(), this.t(), 0);
            }
            case Left: {
                return new PaddedTexture(this.u(), this.v(), distance, this.h, 0, this.textureFile, this.l(), 0, this.t(), this.b());
            }
            case Right: {
                return new PaddedTexture(this.u() + this.w - distance, this.v(), distance, this.h, 0, this.textureFile, 0, this.r(), this.t(), this.b());
            }
            case Upwards: {
                return new PaddedTexture(this.u(), this.v() + this.h - distance, this.w(), distance, 0, this.textureFile, this.l(), this.r(), 0, this.b());
            }
        }
        return this;
    }
}

