/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.mod.database;

import binnie.core.genetics.BreedingSystem;
import binnie.core.util.IValidator;
import binnie.craftgui.controls.ControlTextEdit;
import binnie.craftgui.controls.listbox.ControlListBox;
import binnie.craftgui.controls.listbox.ControlTextOption;
import binnie.craftgui.controls.page.ControlPage;
import binnie.craftgui.controls.page.ControlPages;
import binnie.craftgui.controls.tab.ControlTabBar;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.CraftGUIUtil;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.Position;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventTextEdit;
import binnie.craftgui.events.EventValueChanged;
import binnie.craftgui.minecraft.ControlHelp;
import binnie.craftgui.minecraft.MinecraftGUI;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.mod.database.ControlBranchBox;
import binnie.craftgui.mod.database.ControlSpeciesBox;
import binnie.craftgui.mod.database.DatabaseTab;
import binnie.craftgui.mod.database.IDatabaseMode;
import binnie.craftgui.mod.database.PageAbstract;
import binnie.craftgui.window.Panel;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IClassification;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public abstract class WindowAbstractDatabase
extends Window {
    protected float selectionBoxWidth = 95.0f;
    protected final float infoBoxWidth = 144.0f;
    protected final float infoBoxHeight = 176.0f;
    protected final float infoTabWidth = 16.0f;
    protected final float modeTabWidth = 22.0f;
    protected final float searchBoxHeight = 16.0f;
    protected Map<IDatabaseMode, ModeWidgets> modes = new HashMap<IDatabaseMode, ModeWidgets>();
    boolean isNEI;
    BreedingSystem system;
    protected Panel panelInformation = null;
    protected Panel panelSearch = null;
    protected ControlPages<IDatabaseMode> modePages = null;
    private IAlleleSpecies gotoSpecies = null;

    public void changeMode(IDatabaseMode mode) {
        this.modePages.setValue(mode);
    }

    public WindowAbstractDatabase(EntityPlayer player, Side side, boolean nei, BreedingSystem system, float wid) {
        super(100.0f, 192.0f, player, null, side);
        this.selectionBoxWidth = wid;
        this.setSize(new Vector2f(176.0f + this.selectionBoxWidth + 22.0f + 8.0f, 208.0f));
        this.isNEI = nei;
        this.system = system;
        this.addEventHandler((EventHandler)new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                ControlPage parent;
                if (event.getOrigin().getParent() instanceof ControlPage && !(event.getValue() instanceof DatabaseTab) && (parent = (ControlPage)event.getOrigin().getParent()).getValue() instanceof IDatabaseMode) {
                    for (IWidget widget : parent.getWidgets()) {
                        if (!(widget instanceof ControlPages)) continue;
                        if (event.getValue() == null) {
                            widget.hide();
                            continue;
                        }
                        widget.show();
                        for (IWidget widget2 : widget.getWidgets()) {
                            if (!(widget2 instanceof PageAbstract)) continue;
                            ((PageAbstract)widget2).onValueChanged(event.getValue());
                        }
                    }
                }
            }
        });
        this.addEventHandler(new EventTextEdit.Handler(){

            @Override
            public void onEvent(final EventTextEdit event) {
                for (ModeWidgets widgets : WindowAbstractDatabase.this.modes.values()) {
                    widgets.listBox.setValidator(new IValidator<IWidget>(){

                        @Override
                        public boolean isValid(IWidget object) {
                            return event.getValue() == "" || ((ControlTextOption)object).getText().toLowerCase().contains(((String)event.getValue()).toLowerCase());
                        }
                    });
                }
            }
        }.setOrigin(EventHandler.Origin.DirectChild, this));
    }

    public ControlPages<DatabaseTab> getInfoPages(IDatabaseMode mode) {
        return this.modes.get((Object)mode).infoPages;
    }

    public boolean isNEI() {
        return this.isNEI;
    }

    public BreedingSystem getBreedingSystem() {
        return this.system;
    }

    public WindowAbstractDatabase(EntityPlayer player, Side side, boolean nei, BreedingSystem system) {
        this(player, side, nei, system, 95.0f);
    }

    protected ModeWidgets createMode(IDatabaseMode mode, ModeWidgets widgets) {
        this.modes.put(mode, widgets);
        return widgets;
    }

    @Override
    public void initialize() {
        IBreedingTracker tracker;
        new ControlHelp(this, 4.0f, 4.0f);
        this.panelInformation = new Panel(this, 24.0f, 24.0f, 144.0f, 176.0f, MinecraftGUI.PanelType.Black);
        this.panelInformation.setColour(860416);
        this.panelSearch = new Panel(this, 176.0f, 24.0f, this.selectionBoxWidth, 160.0f, MinecraftGUI.PanelType.Black);
        this.panelSearch.setColour(860416);
        this.modePages = new ControlPages(this, 0.0f, 0.0f, this.getSize().x(), this.getSize().y());
        new ControlTextEdit(this, 176.0f, 184.0f, this.selectionBoxWidth, 16.0f);
        this.createMode(Mode.Species, new ModeWidgets(Mode.Species, this){

            @Override
            public void createListBox(IArea area) {
                GameProfile playerName = WindowAbstractDatabase.this.getUsername();
                Collection<IAlleleSpecies> speciesList = !this.database.isNEI ? this.database.system.getDiscoveredSpecies(this.database.getWorld(), playerName) : this.database.system.getAllSpecies();
                this.listBox = new ControlSpeciesBox(this.modePage, area.x(), area.y(), area.w(), area.h());
                this.listBox.setOptions(speciesList);
            }
        });
        this.createMode(Mode.Branches, new ModeWidgets(Mode.Branches, this){

            @Override
            public void createListBox(IArea area) {
                EntityPlayer player = this.database.getPlayer();
                GameProfile playerName = WindowAbstractDatabase.this.getUsername();
                List<IClassification> speciesList = !this.database.isNEI ? this.database.system.getDiscoveredBranches(this.database.getWorld(), playerName) : this.database.system.getAllBranches();
                this.listBox = new ControlBranchBox(this.modePage, area.x(), area.y(), area.w(), area.h());
                this.listBox.setOptions(speciesList);
            }
        });
        this.createMode(Mode.Breeder, new ModeWidgets(Mode.Breeder, this){

            @Override
            public void createListBox(IArea area) {
                this.listBox = new ControlListBox(this.modePage, area.x(), area.y(), area.w(), area.h(), 12.0f);
            }
        });
        this.addTabs();
        ControlTabBar<IDatabaseMode> tab = new ControlTabBar<IDatabaseMode>(this, 176.0f + this.selectionBoxWidth, 24.0f, 22.0f, 176.0f, Position.Right);
        tab.setValues(this.modePages.getValues());
        CraftGUIUtil.linkWidgets(tab, this.modePages);
        this.changeMode(Mode.Species);
        for (IDatabaseMode mode : this.modes.keySet()) {
            this.modes.get((Object)mode).infoTabs = new ControlTabBar(this.modes.get((Object)mode).modePage, 8.0f, 24.0f, 16.0f, 176.0f, Position.Left);
            this.modes.get((Object)mode).infoTabs.setValues(this.modes.get((Object)mode).infoPages.getValues());
            CraftGUIUtil.linkWidgets(this.modes.get((Object)mode).infoTabs, this.modes.get((Object)mode).infoPages);
        }
        if (this.isServer() && (tracker = this.system.getSpeciesRoot().getBreedingTracker(this.getWorld(), this.getUsername())) != null) {
            tracker.synchToPlayer(this.getPlayer());
        }
    }

    protected void addTabs() {
    }

    public void gotoSpecies(IAlleleSpecies value) {
        if (value != null) {
            this.modePages.setValue(Mode.Species);
            this.changeMode(Mode.Species);
            this.modes.get((Object)this.modePages.getValue()).listBox.setValue(value);
        }
    }

    public void gotoSpeciesDelayed(IAlleleSpecies species) {
        this.gotoSpecies = species;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.gotoSpecies != null) {
            ((WindowAbstractDatabase)this.getSuperParent()).gotoSpecies(this.gotoSpecies);
            this.gotoSpecies = null;
        }
    }

    public static abstract class ModeWidgets {
        WindowAbstractDatabase database;
        public ControlPage<IDatabaseMode> modePage;
        public ControlPages<DatabaseTab> infoPages;
        public ControlListBox listBox;
        public ControlTabBar<DatabaseTab> infoTabs;

        public ModeWidgets(IDatabaseMode mode, WindowAbstractDatabase database) {
            this.database = database;
            this.modePage = new ControlPage<IDatabaseMode>(database.modePages, 0.0f, 0.0f, database.getSize().x(), database.getSize().y(), mode);
            database.modePages.addChild(this.modePage);
            IArea listBoxArea = CraftGUIUtil.getPaddedArea(database.panelSearch, 2);
            this.createListBox(listBoxArea);
            CraftGUIUtil.alignToWidget(this.listBox, database.panelSearch);
            CraftGUIUtil.moveWidget(this.listBox, new Vector2f(2.0f, 2.0f));
            this.infoPages = new ControlPages(this.modePage, 0.0f, 0.0f, database.infoBoxWidth, database.infoBoxHeight);
            CraftGUIUtil.alignToWidget(this.infoPages, database.panelInformation);
        }

        public abstract void createListBox(IArea var1);
    }

    public static enum Mode implements IDatabaseMode
    {
        Species,
        Branches,
        Breeder;

    }
}

