/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.mod.database;

import binnie.core.genetics.BreedingSystem;
import binnie.craftgui.controls.listbox.ControlList;
import binnie.craftgui.controls.listbox.ControlListBox;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.mod.database.ControlMutationItem;
import binnie.craftgui.mod.database.WindowAbstractDatabase;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutation;
import java.util.List;

public class ControlMutationBox
extends ControlListBox<IMutation> {
    private int index;
    private Type type;
    IAlleleSpecies species = null;

    @Override
    public IWidget createOption(IMutation value, int y) {
        return new ControlMutationItem((ControlList)this.getContent(), value, this.species, y);
    }

    public ControlMutationBox(IWidget parent, int x, int y, int width, int height, Type type) {
        super(parent, x, y, width, height, 12.0f);
        this.type = type;
    }

    public void setSpecies(IAlleleSpecies species) {
        if (species != this.species) {
            this.species = species;
            this.index = 0;
            this.movePercentage(-100.0f);
            BreedingSystem system = ((WindowAbstractDatabase)this.getSuperParent()).getBreedingSystem();
            List<IMutation> discovered = system.getDiscoveredMutations(((Window)Window.get(this)).getWorld(), ((Window)Window.get(this)).getUsername());
            if (species != null) {
                if (this.type == Type.Resultant) {
                    this.setOptions(system.getResultantMutations(species));
                } else {
                    List<IMutation> mutations = system.getFurtherMutations(species);
                    int i = 0;
                    while (i < mutations.size()) {
                        IMutation mutation = mutations.get(i);
                        if (!discovered.contains(mutations) && !((IAlleleSpecies)mutation.getTemplate()[0]).isCounted()) {
                            mutations.remove(i);
                            continue;
                        }
                        ++i;
                    }
                    this.setOptions(mutations);
                }
            }
        }
    }

    static enum Type {
        Resultant,
        Further;

    }
}

