/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.mod.database;

import binnie.Binnie;
import binnie.core.genetics.BreedingSystem;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.minecraft.ControlItemDisplay;
import binnie.craftgui.minecraft.IRendererMinecraft;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.mod.database.EnumDiscoveryState;
import binnie.craftgui.mod.database.WindowAbstractDatabase;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import net.minecraft.util.IIcon;

public class ControlIndividualDisplay
extends ControlItemDisplay
implements ITooltip {
    IAlleleSpecies species = null;
    EnumDiscoveryState discovered = EnumDiscoveryState.Show;

    public void setSpecies(IAlleleSpecies species) {
        this.setSpecies(species, EnumDiscoveryState.Show);
    }

    public void setSpecies(IAlleleSpecies species, EnumDiscoveryState state) {
        ISpeciesRoot speciesRoot = Binnie.Genetics.getSpeciesRoot(species);
        BreedingSystem system = Binnie.Genetics.getSystem(speciesRoot.getUID());
        IIndividual ind = system.getSpeciesRoot().templateAsIndividual(system.getSpeciesRoot().getTemplate(species.getUID()));
        super.setItemStack(system.getSpeciesRoot().getMemberStack(ind, system.getDefaultType()));
        this.species = species;
        GameProfile username = ((Window)Window.get(this)).getUsername();
        if (state == EnumDiscoveryState.Undetermined) {
            EnumDiscoveryState enumDiscoveryState = state = system.isSpeciesDiscovered(species, ((Window)Window.get(this)).getWorld(), username) ? EnumDiscoveryState.Discovered : EnumDiscoveryState.Undiscovered;
        }
        if (Window.get(this) instanceof WindowAbstractDatabase && ((WindowAbstractDatabase)Window.get((IWidget)this)).isNEI) {
            state = EnumDiscoveryState.Show;
        }
        this.discovered = state;
        this.addAttribute(Attribute.MouseOver);
    }

    public ControlIndividualDisplay(IWidget parent, int x, int y) {
        this(parent, x, y, 16);
    }

    public ControlIndividualDisplay(IWidget parent, int x, int y, int size) {
        super(parent, x, y, size);
        this.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                if (event.getButton() == 0 && ControlIndividualDisplay.this.species != null && EnumDiscoveryState.Show == ControlIndividualDisplay.this.discovered) {
                    ((WindowAbstractDatabase)ControlIndividualDisplay.this.getSuperParent()).gotoSpeciesDelayed(ControlIndividualDisplay.this.species);
                }
            }
        });
    }

    @Override
    public void onRenderForeground() {
        IIcon icon = null;
        BreedingSystem system = ((WindowAbstractDatabase)this.getSuperParent()).getBreedingSystem();
        switch (this.discovered) {
            case Show: {
                super.onRenderForeground();
                return;
            }
            case Discovered: {
                icon = system.getDiscoveredIcon();
                break;
            }
            case Undiscovered: {
                icon = system.getUndiscoveredIcon();
            }
        }
        if (icon != null) {
            this.getRenderer().subRenderer(IRendererMinecraft.class).renderItemIcon(Vector2f.ZERO, icon);
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (this.species != null) {
            switch (this.discovered) {
                case Show: {
                    tooltip.add(this.species.getName());
                    break;
                }
                case Discovered: {
                    tooltip.add("Discovered Species");
                    break;
                }
                case Undiscovered: {
                    tooltip.add("Undiscovered Species");
                }
            }
        }
    }
}

