/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.IBinnieMod;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.IInventoryMachine;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.PowerSystem;
import binnie.core.network.packet.MessageCraftGUI;
import binnie.core.resource.BinnieResource;
import binnie.core.resource.ResourceType;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.ITooltipHelp;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.TopLevelWidget;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventWidget;
import binnie.craftgui.minecraft.ContainerCraftGUI;
import binnie.craftgui.minecraft.ControlHelp;
import binnie.craftgui.minecraft.ControlInfo;
import binnie.craftgui.minecraft.ControlPowerSystem;
import binnie.craftgui.minecraft.ControlSlot;
import binnie.craftgui.minecraft.ControlUser;
import binnie.craftgui.minecraft.EnumHighlighting;
import binnie.craftgui.minecraft.GuiCraftGUI;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.craftgui.minecraft.IRendererMinecraft;
import binnie.craftgui.minecraft.MinecraftTooltip;
import binnie.craftgui.minecraft.WindowInventory;
import binnie.craftgui.resource.IStyleSheet;
import binnie.craftgui.resource.ITexture;
import binnie.craftgui.resource.StyleSheetManager;
import binnie.craftgui.resource.minecraft.StandardTexture;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class Window
extends TopLevelWidget
implements INetwork.RecieveGuiNBT {
    private GuiCraftGUI gui;
    private ContainerCraftGUI container;
    private WindowInventory windowInventory;
    private ControlText title;
    float buttonsLeft = 8.0f;
    float buttonsRight = 8.0f;
    StandardTexture bgText1 = null;
    StandardTexture bgText2 = null;
    public boolean hasBeenInitialised = false;
    private EntityPlayer player;
    private IInventory entityInventory;
    Side side = Side.CLIENT;
    protected IStyleSheet stylesheet;

    public void getTooltip(Tooltip tooltip) {
        if (this.getMousedOverWidget() instanceof ITooltip) {
            ((ITooltip)((Object)this.getMousedOverWidget())).getTooltip(tooltip);
        }
    }

    public void getHelpTooltip(MinecraftTooltip tooltip) {
        if (this.getMousedOverWidget() instanceof ITooltipHelp) {
            ((ITooltipHelp)((Object)this.getMousedOverWidget())).getHelpTooltip(tooltip);
        }
    }

    protected abstract IBinnieMod getMod();

    protected abstract String getName();

    public BinnieResource getBackgroundTextureFile(int i) {
        return Binnie.Resource.getPNG(this.getMod(), ResourceType.GUI, this.getName() + (i == 1 ? "" : Integer.valueOf(i)));
    }

    public Window(float width, float height, EntityPlayer player, IInventory inventory, Side side) {
        this.side = side;
        this.setSize(new Vector2f(width, height));
        this.setInventories(player, inventory);
        this.container = new ContainerCraftGUI(this);
        this.windowInventory = new WindowInventory(this);
        if (!this.isServer()) {
            this.gui = new GuiCraftGUI(this);
            this.setRenderer(this.gui);
            this.stylesheet = StyleSheetManager.getDefault();
        }
        this.buttonsLeft = -14.0f;
        if (Machine.getInterface(IInventoryMachine.class, this.getInventory()) != null) {
            ControlHelp controlHelp = new ControlHelp(this, this.buttonsLeft += 22.0f, 8.0f);
        }
        if (Machine.getInterface(IMachineInformation.class, this.getInventory()) != null) {
            ControlInfo controlInfo = new ControlInfo(this, this.buttonsLeft += 22.0f, 8.0f);
        }
        Window wind = this;
        this.addSelfEventHandler((EventHandler)new EventWidget.ChangeSize.Handler(){

            @Override
            public void onEvent(EventWidget.ChangeSize event) {
                if (Window.this.isClient() && Window.this.getGui() != null) {
                    Window.this.getGui().resize(Window.this.getSize());
                    if (Window.this.title != null) {
                        Window.this.title.setSize(new Vector2f(Window.this.w(), Window.this.title.h()));
                    }
                }
            }
        });
    }

    public void setTitle(String title) {
        this.title = new ControlTextCentered((IWidget)this, 12.0f, title);
        this.title.setColour(0x404040);
    }

    @SideOnly(value=Side.CLIENT)
    public final GuiCraftGUI getGui() {
        return this.gui;
    }

    public final ContainerCraftGUI getContainer() {
        return this.container;
    }

    public final WindowInventory getWindowInventory() {
        return this.windowInventory;
    }

    public final void initGui() {
        if (this.hasBeenInitialised) {
            return;
        }
        this.bgText1 = new StandardTexture(0, 0, 256, 256, this.getBackgroundTextureFile(1));
        if (this.getSize().x() > 256.0f) {
            this.bgText2 = new StandardTexture(0, 0, 256, 256, this.getBackgroundTextureFile(2));
        }
        if (!BinnieCore.proxy.checkTexture(this.bgText1.getTexture())) {
            this.bgText1 = null;
            this.bgText2 = null;
        }
        this.initialize();
        this.hasBeenInitialised = true;
    }

    public abstract void initialize();

    @Override
    public void onRenderBackground() {
        this.getRenderer(IRendererMinecraft.class).renderWindow(this);
    }

    @Override
    public void onRenderForeground() {
    }

    @Override
    public void onRenderOverlay() {
    }

    @Override
    public void onUpdate() {
        ControlSlot.highlighting.get((Object)EnumHighlighting.Help).clear();
        ControlSlot.highlighting.get((Object)EnumHighlighting.ShiftClick).clear();
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public GameProfile getUsername() {
        return this.getPlayer().func_146103_bH();
    }

    public ItemStack getHeldItemStack() {
        if (this.player != null) {
            return this.player.field_71071_by.func_70445_o();
        }
        return null;
    }

    public IInventory getInventory() {
        return this.entityInventory;
    }

    public void setInventories(EntityPlayer player2, IInventory inventory) {
        this.player = player2;
        this.entityInventory = inventory;
    }

    public void onClose() {
    }

    public void setHeldItemStack(ItemStack stack) {
        if (this.player != null) {
            this.player.field_71071_by.func_70437_b(stack);
        }
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public boolean isClient() {
        return this.side == Side.CLIENT;
    }

    public World getWorld() {
        if (this.getPlayer() != null) {
            return this.getPlayer().field_70170_p;
        }
        return BinnieCore.proxy.getWorld();
    }

    public void onInventoryUpdate() {
    }

    public void sendClientAction(String name, NBTTagCompound action) {
        action.func_74778_a("type", name);
        MessageCraftGUI packet = new MessageCraftGUI(action);
        BinnieCore.proxy.sendToServer(packet);
    }

    @Override
    public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound action) {
        if (side == Side.CLIENT && name.equals("username")) {
            ControlUser controlUser = new ControlUser(this, this.w() - (this.buttonsRight += 16.0f), 8.0f, action.func_74779_i("username"));
            this.buttonsRight += 6.0f;
        }
        if (side == Side.CLIENT && name.equals("power-system")) {
            ControlPowerSystem controlPowerSystem = new ControlPowerSystem(this, this.w() - (this.buttonsRight += 16.0f), 8.0f, PowerSystem.get(action.func_74771_c("system")));
            this.buttonsRight += 6.0f;
        }
    }

    @Override
    public ITexture getTexture(Object key) {
        return this.stylesheet.getTexture(key);
    }

    public void onWindowInventoryChanged() {
    }

    public ITexture getBackground1() {
        return this.bgText1;
    }

    public ITexture getBackground2() {
        return this.bgText2;
    }

    public static <T extends Window> T get(IWidget widget) {
        return (T)((Window)widget.getSuperParent());
    }
}

