/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.core.BinnieCore;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.Direction;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPosition;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.core.renderer.IRendererWidget;
import binnie.craftgui.events.EventKey;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.minecraft.IRendererMinecraft;
import binnie.craftgui.minecraft.MinecraftTooltip;
import binnie.craftgui.minecraft.RendererWidgetMinecraft;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.ITexture;
import binnie.craftgui.resource.ITexturePadded;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import binnie.craftgui.resource.minecraft.StandardTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiCraftGUI
extends GuiContainer
implements IRendererMinecraft {
    Vector2f mousePos = new Vector2f(0.0f, 0.0f);
    Window window;
    ItemStack draggedItem;
    ITexture currentTexture;
    int currentColour = 0xFFFFFF;
    IWidget currentWidget;
    Map<Class<?>, Object> subRenderers = new HashMap();

    public void func_73876_c() {
        this.window.update();
    }

    public Minecraft getMinecraft() {
        return this.field_146297_k;
    }

    public GuiCraftGUI(Window window) {
        super((Container)window.getContainer());
        this.window = window;
        this.resize(window.getSize());
        this.addSubRenderer(IRendererWidget.class, new RendererWidgetMinecraft(this));
    }

    protected void func_146976_a(float var1, int var2, int var3) {
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.window.setSize(new Vector2f(this.field_146999_f, this.field_147000_g));
        this.window.setPosition(new Vector2f(this.field_147003_i, this.field_147009_r));
        this.window.initGui();
    }

    public ItemStack getDraggedItem() {
        return this.draggedItem;
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        this.window.setMousePosition(mouseX - (int)this.window.getPosition().x(), mouseY - (int)this.window.getPosition().y());
        this.func_146276_q_();
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.field_73735_i = 10.0f;
        this.window.renderBackground();
        this.window.renderForeground();
        this.window.renderOverlay();
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        InventoryPlayer playerInventory = this.field_146297_k.field_71439_g.field_71071_by;
        this.draggedItem = playerInventory.func_70445_o();
        if (this.draggedItem != null) {
            this.renderItem(new Vector2f(mouseX - 8, mouseY - 8), this.draggedItem, 200);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        MinecraftTooltip tooltip = new MinecraftTooltip();
        if (this.isHelpMode()) {
            tooltip.setType(Tooltip.Type.Help);
            this.window.getHelpTooltip(tooltip);
        } else {
            tooltip.setType(Tooltip.Type.Standard);
            this.window.getTooltip(tooltip);
        }
        if (tooltip.exists()) {
            this.renderTooltip(new Vector2f(mouseX, mouseY), tooltip);
        }
        this.field_73735_i = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public void renderTooltip(IPosition mousePosition, MinecraftTooltip tooltip) {
        int i2;
        int mouseX = (int)mousePosition.x();
        int mouseY = (int)mousePosition.y();
        FontRenderer font = this.getFontRenderer();
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int k = 0;
        ArrayList strings = new ArrayList();
        for (String string : tooltip.getList()) {
            if (string == null) continue;
            strings.addAll(font.func_78271_c(string, tooltip.maxWidth));
        }
        for (String s : strings) {
            int l = font.func_78256_a(s);
            if (l <= k) continue;
            k = l;
        }
        int i1 = mouseX + 12;
        int j1 = mouseY - 12;
        int k1 = 8;
        if (strings.size() > 1) {
            k1 += 2 + (strings.size() - 1) * 10;
        }
        if (i1 + k > this.field_146294_l) {
            i1 -= 28 + k;
        }
        if (j1 + k1 + 6 > this.field_146295_m) {
            j1 = this.field_146295_m - k1 - 6;
        }
        this.field_73735_i = 300.0f;
        GuiCraftGUI.field_146296_j.field_77023_b = 300.0f;
        int l1 = -267386864;
        int j2 = i2 = 0x50000000 + MinecraftTooltip.getOutline(tooltip.getType());
        this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
        this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
        this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
        for (int k2 = 0; k2 < strings.size(); ++k2) {
            String s1 = (String)strings.get(k2);
            s1 = k2 == 0 ? MinecraftTooltip.getTitle(tooltip.getType()) + s1 : MinecraftTooltip.getBody(tooltip.getType()) + s1;
            font.func_78261_a(s1, i1, j1, -1);
            if (k2 == 0) {
                j1 += 2;
            }
            j1 += 10;
        }
        this.field_73735_i = 0.0f;
        GuiCraftGUI.field_146296_j.field_77023_b = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    protected void func_73864_a(int x, int y, int button) {
        IWidget origin = this.window;
        if (this.window.getMousedOverWidget() != null) {
            origin = this.window.getMousedOverWidget();
        }
        this.window.callEvent(new EventMouse.Down(origin, x, y, button));
    }

    public boolean isShiftDown() {
        return Keyboard.isKeyDown((int)this.field_146297_k.field_71474_y.field_74311_E.func_151463_i());
    }

    protected void func_73869_a(char c, int key) {
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() && this.window.getFocusedWidget() == null) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        IWidget origin = this.window.getFocusedWidget() == null ? this.window : this.window.getFocusedWidget();
        this.window.callEvent(new EventKey.Down(origin, c, key));
    }

    protected void func_146286_b(int x, int y, int button) {
        IWidget origin;
        IWidget iWidget = origin = this.window.getMousedOverWidget() == null ? this.window : this.window.getMousedOverWidget();
        if (button == -1) {
            float dx = (float)Mouse.getEventDX() * (float)this.field_146294_l / (float)this.field_146297_k.field_71443_c;
            float dy = -((float)Mouse.getEventDY() * (float)this.field_146295_m / (float)this.field_146297_k.field_71440_d);
        } else {
            this.window.callEvent(new EventMouse.Up(origin, x, y, button));
        }
    }

    public void func_146274_d() {
        IWidget origin;
        super.func_146274_d();
        int dWheel = Mouse.getDWheel();
        IWidget iWidget = origin = this.window.getFocusedWidget() == null ? this.window : this.window.getFocusedWidget();
        if (dWheel != 0) {
            this.window.callEvent(new EventMouse.Wheel(this.window, dWheel));
        }
    }

    public void func_146281_b() {
        this.window.onClose();
    }

    private void renderTexturedRect(float x, float y, float u, float v, float w, float h) {
        this.func_73729_b((int)x, (int)y, (int)u, (int)v, (int)w, (int)h);
    }

    public void renderTexture(IPosition position, IArea textureArea) {
        this.func_73729_b((int)position.x(), (int)position.y(), (int)textureArea.pos().x(), (int)textureArea.pos().y(), (int)textureArea.size().x(), (int)textureArea.size().y());
    }

    private void renderTexturedRect(IArea area, IPosition uv) {
        this.renderTexturedRect(area.pos().x(), area.pos().y(), uv.x(), uv.y(), area.size().x(), area.size().y());
    }

    @Override
    public void renderTexture(Object key, IPosition position) {
        ITexture texture = this.getTexture(key);
        if (texture == null) {
            return;
        }
        this.setTexture(texture);
        this.renderTexturedRect(position.x(), position.y(), texture.u(), texture.v(), texture.w(), texture.h());
    }

    @Override
    public void renderTexture(Object key, IArea area) {
        ITexture texture = this.getTexture(key);
        if (texture == null) {
            return;
        }
        if (texture instanceof ITexturePadded && ((float)texture.w() != area.size().x() || (float)texture.h() != area.size().y())) {
            this.renderTexturePadded((ITexturePadded)texture, area);
        } else {
            this.renderTexture((Object)texture, area.pos());
        }
    }

    @Override
    public void renderTextureTiled(Object key, IArea area) {
        ITexture texture = this.getTexture(key);
        this.renderTexturePadded(texture, area, new Area(0.0f, 0.0f, 0.0f, 0.0f));
    }

    private void renderTexturePadded(ITexturePadded texture, IArea area) {
        this.renderTexturePadded(texture, area, new Area(texture.l(), texture.r(), texture.t(), texture.b()));
    }

    private void renderTexturePadded(ITexture texture, IArea area, IArea padding) {
        int texturingHeight;
        int texturingWidth;
        this.setTexture(texture);
        int borderLeft = (int)padding.pos().x();
        int borderRight = (int)padding.pos().y();
        int borderTop = (int)padding.size().x();
        int borderBottom = (int)padding.size().y();
        int posX = (int)area.pos().x();
        int posY = (int)area.pos().y();
        int width = (int)area.size().x();
        int height = (int)area.size().y();
        int textWidth = texture.w();
        int textHeight = texture.h();
        int u = texture.u();
        int v = texture.v();
        if (borderTop + borderBottom > height) {
            return;
        }
        IPosition origin = area.pos();
        this.func_73729_b(posX, posY, u, v, borderLeft, borderTop);
        this.func_73729_b(posX + width - borderRight, posY, u + textWidth - borderRight, v, borderRight, borderTop);
        this.func_73729_b(posX, posY + height - borderBottom, u, v + textHeight - borderBottom, borderLeft, borderBottom);
        this.func_73729_b(posX + width - borderRight, posY + height - borderBottom, u + textWidth - borderRight, v + textHeight - borderBottom, borderRight, borderBottom);
        for (int currentXPos = borderLeft; currentXPos < width - borderRight; currentXPos += texturingWidth) {
            int texturingHeight2;
            texturingWidth = textWidth - borderLeft - borderRight;
            int distanceXRemaining = width - borderRight - currentXPos;
            if (texturingWidth > distanceXRemaining) {
                texturingWidth = distanceXRemaining;
            }
            this.func_73729_b(posX + currentXPos, posY, u + borderLeft, v, texturingWidth, borderTop);
            this.func_73729_b(posX + currentXPos, posY + height - borderBottom, u + borderLeft, v + textHeight - borderBottom, texturingWidth, borderBottom);
            for (int currentYPos = borderTop; currentYPos < height - borderBottom; currentYPos += texturingHeight2) {
                texturingHeight2 = textHeight - borderTop - borderBottom;
                int distanceYRemaining = height - borderBottom - currentYPos;
                if (texturingHeight2 > distanceYRemaining) {
                    texturingHeight2 = distanceYRemaining;
                }
                this.func_73729_b(posX + currentXPos, posY + currentYPos, u + borderLeft, v + borderTop, texturingWidth, texturingHeight2);
            }
        }
        for (int currentYPos = borderTop; currentYPos < height - borderBottom; currentYPos += texturingHeight) {
            texturingHeight = textHeight - borderTop - borderBottom;
            int distanceYRemaining = height - borderBottom - currentYPos;
            if (texturingHeight > distanceYRemaining) {
                texturingHeight = distanceYRemaining;
            }
            this.func_73729_b(posX, posY + currentYPos, u, v + borderTop, borderLeft, texturingHeight);
            this.func_73729_b(posX + width - borderRight, posY + currentYPos, u + textWidth - borderRight, v + borderTop, borderRight, texturingHeight);
        }
    }

    @Override
    public void setTexture(ITexture texture) {
        if (!(texture instanceof StandardTexture)) {
            return;
        }
        if (texture != this.currentTexture && texture != null) {
            BinnieCore.proxy.bindTexture(((StandardTexture)texture).getTexture());
        }
        this.setColour(this.currentColour);
    }

    @Override
    public int getTextWidth(String text) {
        return this.getFontRenderer().func_78256_a(text);
    }

    @Override
    public int getTextHeight() {
        return this.getFontRenderer() == null ? 0 : this.getFontRenderer().field_78288_b;
    }

    @Override
    public void renderText(IPosition pos, String text, int colour) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)20.0f);
        this.renderText(new Area(pos, new Vector2f(500.0f, 500.0f)), TextJustification.TopLeft, text, colour);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-20.0f);
        GL11.glPopMatrix();
    }

    @Override
    public void renderText(IArea area, TextJustification justification, String text, int colour) {
        IPosition pos = area.pos();
        if (area.size().x() <= 0.0f) {
            return;
        }
        List wrappedStrings = this.getFontRenderer().func_78271_c(text, (int)area.size().x());
        float totalHeight = wrappedStrings.size() * this.getTextHeight();
        float posY = area.pos().y();
        if (area.size().y() > totalHeight) {
            posY += (area.size().y() - totalHeight) * justification.getYOffset();
        }
        for (String string : wrappedStrings) {
            float stringWidth = this.getTextWidth(string);
            float posX = area.size().x() - stringWidth;
            GL11.glDisable((int)2929);
            this.getFontRenderer().func_78276_b(string, (int)(pos.x() + (posX *= justification.getXOffset())), (int)(pos.y() + posY), colour);
            GL11.glEnable((int)2929);
            posY += (float)this.getTextHeight();
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void renderSolidArea(IArea area, int colour) {
        Gui.func_73734_a((int)((int)area.pos().x()), (int)((int)area.pos().y()), (int)((int)(area.pos().x() + area.size().x())), (int)((int)(area.pos().y() + area.size().y())), (int)(0xFF000000 | colour));
        this.renderGradientRect(area, colour, colour);
    }

    @Override
    public void renderItem(IPosition pos, ItemStack item) {
        this.renderItem(pos, item, (int)(this.field_73735_i + 3.0f));
    }

    private void renderItem(IPosition pos, ItemStack item, int zLevel) {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        GuiCraftGUI.field_146296_j.field_77023_b = zLevel + 50;
        FontRenderer font = item.func_77973_b().getFontRenderer(item);
        if (font == null) {
            font = this.getFontRenderer();
        }
        if (item != null) {
            field_146296_j.func_82406_b(font, this.field_146297_k.field_71446_o, item, (int)pos.x(), (int)pos.y());
            field_146296_j.func_94148_a(font, this.field_146297_k.field_71446_o, item, (int)pos.x(), (int)pos.y(), null);
        }
        GL11.glEnable((int)3042);
        RenderHelper.func_74518_a();
        this.setColour(-1);
        GL11.glEnable((int)32826);
        GL11.glPopMatrix();
    }

    @Override
    public void renderBlockIcon(IPosition pos, IIcon icon) {
        this.renderIcon(pos, icon, TextureMap.field_110575_b);
    }

    @Override
    public void renderItemIcon(IPosition pos, IIcon icon) {
        this.renderIcon(pos, icon, TextureMap.field_110576_c);
    }

    private void renderIcon(IPosition pos, IIcon icon, ResourceLocation map) {
        if (icon == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        BinnieCore.proxy.bindTexture(map);
        GuiCraftGUI.field_146296_j.field_77023_b = this.field_73735_i;
        field_146296_j.func_94149_a((int)pos.x(), (int)pos.y(), icon, 16, 16);
        GL11.glEnable((int)32826);
        GL11.glPopMatrix();
    }

    @Override
    public void renderGradientRect(IArea area, int c1, int c2) {
        this.func_73733_a((int)area.pos().x(), (int)area.pos().y(), (int)(area.pos().x() + area.size().x()), (int)(area.pos().y() + area.size().y()), c1, c2);
    }

    @Override
    public void setColour(int hex) {
        this.currentColour = hex;
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        GL11.glColor3f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f));
    }

    @Override
    public void limitArea(IArea area) {
        float x = (int)area.pos().x();
        float y = (int)area.pos().y();
        float w = (int)area.size().x();
        float h = (int)area.size().y();
        y = (float)this.field_146295_m - (y + h);
        float k = this.field_146999_f;
        float scaleX = (float)this.field_146294_l / (float)this.field_146297_k.field_71443_c;
        float scaleY = (float)this.field_146295_m / (float)this.field_146297_k.field_71440_d;
        GL11.glScissor((int)((int)((x += 0.0f) / scaleX)), (int)((int)((y += 0.0f) / scaleY)), (int)((int)((w += 0.0f) / scaleX) + 2), (int)((int)((h += 0.0f) / scaleY)));
    }

    @Override
    public float getTextHeight(String text, float width) {
        return this.getFontRenderer().func_78271_c(text, (int)width).size() * this.getFontRenderer().field_78288_b;
    }

    @Override
    public void renderSubTexture(ITexture texture, IArea area, Direction direction, float percentage) {
        float x = area.pos().x();
        float y = area.pos().y();
        float w = area.size().x();
        float h = area.size().y();
        float u = texture.u();
        float v = texture.v();
        switch (direction) {
            case Downwards: {
                h *= percentage;
                break;
            }
            case Left: {
                x += (1.0f - percentage) * w;
                u += (1.0f - percentage) * w;
                w *= percentage;
                break;
            }
            case Right: {
                w *= percentage;
                break;
            }
            case Upwards: {
                y += h - (float)((int)(percentage * h));
                v += (float)(texture.h() - (int)(percentage * (float)texture.h()));
                h *= percentage;
            }
        }
        this.setTexture(texture);
        this.renderTexturedRect(x, y, u, v, w, h);
    }

    @Override
    public ITexture getTexture(Object key) {
        if (key instanceof ITexture) {
            return (ITexture)key;
        }
        return this.currentWidget.getTexture(key);
    }

    @Override
    public void setWidget(IWidget widget) {
        this.currentWidget = widget;
        if (widget != null) {
            this.field_73735_i = widget.getLevel();
            for (IWidget parent = widget; parent != null; parent = parent.getParent()) {
            }
        }
    }

    @Override
    public <T> T subRenderer(Class<T> renderer) {
        if (this.subRenderers.containsKey(renderer)) {
            return (T)this.subRenderers.get(renderer);
        }
        return (T)this;
    }

    @Override
    public void renderWindow(Window window) {
        this.setColour(0xFFFFFF);
        if (window.getBackground1() != null) {
            this.renderTexture((Object)window.getBackground1(), Vector2f.ZERO);
        }
        if (window.getBackground2() != null) {
            this.renderTexture((Object)window.getBackground2(), new Vector2f(256.0f, 0.0f));
        }
        this.setColour(window.getColour());
        this.renderTexture((Object)CraftGUITexture.Window, window.getArea());
    }

    @Override
    public <T> void addSubRenderer(Class<T> rendererClass, T renderer) {
        this.subRenderers.put(rendererClass, renderer);
    }

    public boolean isHelpMode() {
        return Keyboard.isKeyDown((int)15);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void resize(IPosition size) {
        this.field_146999_f = (int)size.x();
        this.field_147000_g = (int)size.y();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.window.setPosition(new Vector2f(this.field_147003_i, this.field_147009_r));
    }
}

