/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.MachineSide;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.CraftGUIUtil;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.minecraft.ControlPlayerInventory;
import binnie.craftgui.minecraft.ControlSlotArray;
import binnie.craftgui.minecraft.ControlSlotBase;
import binnie.craftgui.minecraft.CustomSlot;
import binnie.craftgui.minecraft.EnumHighlighting;
import binnie.craftgui.minecraft.GuiCraftGUI;
import binnie.craftgui.minecraft.IRendererMinecraft;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ControlSlot
extends ControlSlotBase {
    public static Map<EnumHighlighting, List<Integer>> highlighting = new HashMap<EnumHighlighting, List<Integer>>();
    public Slot slot = null;

    public ControlSlot(IWidget parent, float x, float y) {
        super(parent, x, y);
        if (((Window)Window.get(this)).isClient()) {
            this.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

                @Override
                public void onEvent(EventMouse.Down event) {
                    if (ControlSlot.this.slot != null) {
                        PlayerControllerMP playerControllerMP = ((Window)ControlSlot.this.getSuperParent()).getGui().getMinecraft().field_71442_b;
                        int n = ((Window)ControlSlot.this.getSuperParent()).getContainer().field_75152_c;
                        int n2 = ControlSlot.this.slot.field_75222_d;
                        int n3 = event.getButton();
                        ((Window)Window.get(ControlSlot.this.getWidget())).getGui();
                        playerControllerMP.func_78753_a(n, n2, n3, GuiCraftGUI.func_146272_n() ? 1 : 0, (EntityPlayer)((Window)ControlSlot.this.getSuperParent()).getGui().getMinecraft().field_71439_g);
                    }
                }
            });
        }
    }

    public ControlSlot(IWidget parent, int x, int y, Slot slot) {
        super(parent, x, y);
        this.slot = slot;
    }

    @Override
    public void onRenderBackground() {
        IIcon icon;
        this.getRenderer().renderTexture((Object)CraftGUITexture.Slot, Vector2f.ZERO);
        if (this.slot == null) {
            return;
        }
        InventorySlot islot = this.getInventorySlot();
        if (islot != null && islot.getValidator() != null && (icon = islot.getValidator().getIcon(!islot.getInputSides().isEmpty())) != null) {
            this.getRenderer(IRendererMinecraft.class).renderItemIcon(new Vector2f(1.0f, 1.0f), icon);
        }
        boolean highlighted = false;
        for (Map.Entry<EnumHighlighting, List<Integer>> highlight : highlighting.entrySet()) {
            if (highlighted || !highlight.getValue().contains(this.slot.field_75222_d)) continue;
            highlighted = true;
            int c = -1442840576 + Math.max(highlight.getKey().getColour(), 0xFFFFFF);
            this.getRenderer().renderGradientRect(new Area(1.0f, 1.0f, 16.0f, 16.0f), c, c);
        }
        if (!highlighted && this.getSuperParent().getMousedOverWidget() == this) {
            if (((Window)Window.get(this)).getGui().getDraggedItem() != null && !this.slot.func_75214_a(((Window)Window.get(this)).getGui().getDraggedItem())) {
                this.getRenderer().renderGradientRect(new Area(1.0f, 1.0f, 16.0f, 16.0f), -1426089575, -1426089575);
            } else {
                this.getRenderer().renderGradientRect(new Area(1.0f, 1.0f, 16.0f, 16.0f), -2130706433, -2130706433);
            }
        }
    }

    @Override
    public void onRenderOverlay() {
        if (this.slot == null) {
            return;
        }
        boolean highlighted = false;
        for (Map.Entry<EnumHighlighting, List<Integer>> highlight : highlighting.entrySet()) {
            if (highlighted || !highlight.getValue().contains(this.slot.field_75222_d)) continue;
            highlighted = true;
            int c = highlight.getKey().getColour();
            IArea area = this.getArea();
            if (this.getParent() instanceof ControlSlotArray || this.getParent() instanceof ControlPlayerInventory) {
                area = this.getParent().getArea();
                area.setPosition(Vector2f.ZERO.sub(this.getPosition()));
            }
            this.getRenderer().setColour(c);
            this.getRenderer().renderTexture((Object)CraftGUITexture.Outline, CraftGUIUtil.getPaddedArea(area, -1));
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        ((Window)Window.get(this)).getGui();
        if (this.isMouseOver() && GuiScreen.func_146272_n()) {
            ((Window)Window.get(this)).getContainer().setMouseOverSlot(this.slot);
        }
        if (((Window)Window.get(this)).getGui().isHelpMode() && this.isMouseOver()) {
            for (ControlSlot slot2 : this.getControlSlots()) {
                highlighting.get((Object)EnumHighlighting.Help).add(slot2.slot.field_75222_d);
            }
            return;
        }
    }

    private List<ControlSlot> getControlSlots() {
        ArrayList<ControlSlot> slots = new ArrayList<ControlSlot>();
        if (this.getParent() instanceof ControlSlotArray || this.getParent() instanceof ControlPlayerInventory) {
            for (IWidget child : this.getParent().getWidgets()) {
                slots.add((ControlSlot)child);
            }
        } else {
            slots.add(this);
        }
        return slots;
    }

    @Override
    public ItemStack getItemStack() {
        if (this.slot != null) {
            return this.slot.func_75211_c();
        }
        return null;
    }

    public ControlSlot create(IInventory inventory, int index) {
        if (this.slot != null) {
            return this;
        }
        this.slot = this.createSlot(inventory, index);
        ((Window)this.getSuperParent()).getContainer().newSlot(this.slot);
        return this;
    }

    protected Slot createSlot(IInventory inventory, int index) {
        return new CustomSlot(inventory, index, 0, 0);
    }

    @Override
    public void getHelpTooltip(Tooltip tooltip) {
        InventorySlot slot = this.getInventorySlot();
        if (this.getInventorySlot() != null) {
            tooltip.add(slot.getName());
            tooltip.add("Insert Side: " + MachineSide.asString(slot.getInputSides()));
            tooltip.add("Extract Side: " + MachineSide.asString(slot.getOutputSides()));
            if (slot.isReadOnly()) {
                tooltip.add("Pickup Only Slot");
            }
            tooltip.add("Accepts: " + (slot.getValidator() == null ? "Any Item" : slot.getValidator().getTooltip()));
        } else if (this.slot.field_75224_c instanceof InventoryPlayer) {
            tooltip.add("Player Inventory");
        }
    }

    public InventorySlot getInventorySlot() {
        return this.slot instanceof CustomSlot ? ((CustomSlot)this.slot).getInventorySlot() : null;
    }

    static {
        for (EnumHighlighting h : EnumHighlighting.values()) {
            highlighting.put(h, new ArrayList());
        }
    }
}

