/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.core.machines.Machine;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.power.ProcessInfo;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.minecraft.Window;

public class ControlProgressBase
extends Control {
    protected float progress = 0.0f;

    public ControlProgressBase(IWidget parent, float x, float y, float w, float h) {
        super(parent, x, y, w, h);
        this.addAttribute(Attribute.MouseOver);
    }

    public void setProgress(float progress) {
        this.progress = progress;
        if (this.progress < 0.0f) {
            this.progress = 0.0f;
        } else if (this.progress > 1.0f) {
            this.progress = 1.0f;
        }
    }

    private ProcessInfo getProcess() {
        return ((Window)Window.get(this)).getContainer().getProcessInfo();
    }

    @Override
    public void onUpdate() {
        ProcessInfo process = this.getProcess();
        if (process != null) {
            this.setProgress(process.getCurrentProgress() / 100.0f);
        }
    }

    @Override
    public void getHelpTooltip(Tooltip tooltip) {
        ProcessInfo process = this.getProcess();
        IProcess machineProcess = Machine.getMachine(((Window)Window.get(this)).getInventory()).getInterface(IProcess.class);
        if (process != null) {
            tooltip.add("Progress");
            if (this.progress == 0.0f) {
                tooltip.add("Not in Progress");
            } else if (process.getProcessTime() > 0) {
                tooltip.add(machineProcess.getTooltip() + " (" + (int)process.getCurrentProgress() + "%)");
            } else {
                tooltip.add("In Progress");
            }
            if (process.getProcessTime() > 0) {
                tooltip.add("Time Left: " + ControlProgressBase.convertTime((int)((1.0f - this.progress) * (float)process.getProcessTime())));
                tooltip.add("Total Time: " + ControlProgressBase.convertTime(process.getProcessTime()));
                tooltip.add("Energy Cost: " + process.getProcessEnergy() + " MJ");
            } else {
                tooltip.add("Energy Cost: " + process.getEnergyPerTick() + " MJ / tick");
            }
        }
    }

    public static String convertTime(int time) {
        int seconds;
        int minutes = 0;
        for (seconds = (int)((float)time / 20.0f); seconds >= 60; seconds -= 60) {
            ++minutes;
        }
        String ts = "";
        if (minutes > 0) {
            ts = ts + minutes + " minute" + (minutes == 1 ? "" : "s");
        }
        if (seconds > 0) {
            if (ts.length() > 0) {
                ts = ts + " ";
            }
            ts = ts + seconds + " second" + (seconds == 1 ? "" : "s");
        }
        return ts;
    }
}

