/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.core.BinnieCore;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.TankInfo;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.CraftGUIUtil;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPosition;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.minecraft.IRendererMinecraft;
import binnie.craftgui.minecraft.MinecraftTooltip;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class ControlLiquidTank
extends Control
implements ITooltip {
    public static List<Integer> tankError = new ArrayList<Integer>();
    protected int tankID = 0;
    boolean horizontal = false;

    public ControlLiquidTank(IWidget parent, int x, int y) {
        this(parent, x, y, false);
    }

    public ControlLiquidTank(IWidget parent, int x, int y, boolean horizontal) {
        super(parent, x, y, horizontal ? 60.0f : 18.0f, horizontal ? 18.0f : 60.0f);
        this.horizontal = horizontal;
        this.addAttribute(Attribute.MouseOver);
        this.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                if (event.getButton() == 0) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74774_a("id", (byte)ControlLiquidTank.this.tankID);
                    ((Window)Window.get(ControlLiquidTank.this.getWidget())).sendClientAction("tank-click", nbt);
                }
            }
        });
    }

    public void setTankID(int tank) {
        this.tankID = tank;
    }

    public TankInfo getTank() {
        return ((Window)Window.get(this)).getContainer().getTankInfo(this.tankID);
    }

    public boolean isTankValid() {
        return !this.getTank().isEmpty();
    }

    public int getTankCapacity() {
        return (int)this.getTank().getCapacity();
    }

    @Override
    public void onRenderBackground() {
        this.getRenderer().renderTexture((Object)(this.horizontal ? CraftGUITexture.HorizontalLiquidTank : CraftGUITexture.LiquidTank), Vector2f.ZERO);
        if (this.isMouseOver() && ((Window)Window.get(this)).getGui().isHelpMode()) {
            int c = -1442840576 + MinecraftTooltip.getOutline(Tooltip.Type.Help);
            this.getRenderer().renderGradientRect(CraftGUIUtil.getPaddedArea(this.getArea(), 1), c, c);
        } else if (tankError.contains(this.tankID)) {
            int c = -1442840576 + MinecraftTooltip.getOutline(MinecraftTooltip.Type.Error);
            this.getRenderer().renderGradientRect(CraftGUIUtil.getPaddedArea(this.getArea(), 1), c, c);
        } else if (this.getSuperParent().getMousedOverWidget() == this) {
            if (((Window)Window.get(this)).getGui().getDraggedItem() != null) {
                this.getRenderer().renderGradientRect(CraftGUIUtil.getPaddedArea(this.getArea(), 1), -1426089575, -1426089575);
            } else {
                this.getRenderer().renderGradientRect(CraftGUIUtil.getPaddedArea(this.getArea(), 1), -2130706433, -2130706433);
            }
        }
    }

    @Override
    public void onRenderForeground() {
        if (this.isTankValid()) {
            Object content = null;
            float height = this.horizontal ? 16.0f : 58.0f;
            int squaled = (int)(height * (this.getTank().getAmount() / this.getTank().getCapacity()));
            int yPos = (int)height + 1;
            Fluid fluid = this.getTank().liquid.getFluid();
            int hex = fluid.getColor(this.getTank().liquid);
            int r = (hex & 0xFF0000) >> 16;
            int g = (hex & 0xFF00) >> 8;
            int b = hex & 0xFF;
            GL11.glColor4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            IPosition pos = this.getAbsolutePosition();
            Vector2f offset = new Vector2f(0.0f, height - (float)squaled);
            IArea limited = CraftGUIUtil.getPaddedArea(this.getArea(), 1);
            if (this.horizontal) {
                limited.setSize(new Vector2f(limited.w() - 1.0f, limited.h()));
            }
            this.getRenderer().limitArea(new Area(limited.pos().add(pos).add(offset), limited.size().sub(offset)));
            GL11.glEnable((int)3089);
            BinnieCore.proxy.bindTexture(TextureMap.field_110576_c);
            int y = 0;
            while ((float)y < height) {
                for (int x = 0; x < (this.horizontal ? 58 : 16); x += 16) {
                    IIcon icon = fluid.getIcon();
                    this.getRenderer().subRenderer(IRendererMinecraft.class).renderBlockIcon(new Vector2f(1 + x, 1 + y), icon);
                }
                y += 16;
            }
            GL11.glDisable((int)3089);
            GL11.glDisable((int)3042);
        }
    }

    @Override
    public void onRenderOverlay() {
        IArea area;
        this.getRenderer().renderTexture((Object)(this.horizontal ? CraftGUITexture.HorizontalLiquidTankOverlay : CraftGUITexture.LiquidTankOverlay), Vector2f.ZERO);
        if (this.isMouseOver() && ((Window)Window.get(this)).getGui().isHelpMode()) {
            area = this.getArea();
            this.getRenderer().setColour(MinecraftTooltip.getOutline(Tooltip.Type.Help));
            this.getRenderer().renderTexture((Object)CraftGUITexture.Outline, CraftGUIUtil.getPaddedArea(area, -1));
        }
        if (tankError.contains(this.tankID)) {
            area = this.getArea();
            this.getRenderer().setColour(MinecraftTooltip.getOutline(MinecraftTooltip.Type.Error));
            this.getRenderer().renderTexture((Object)CraftGUITexture.Outline, CraftGUIUtil.getPaddedArea(area, -1));
        }
    }

    @Override
    public void getHelpTooltip(Tooltip tooltip) {
        if (this.getTankSlot() != null) {
            TankSlot slot = this.getTankSlot();
            tooltip.add(slot.getName());
            tooltip.add("Capacity: " + this.getTankCapacity() + " mB");
            tooltip.add("Insert Side: " + MachineSide.asString(slot.getInputSides()));
            tooltip.add("Extract Side: " + MachineSide.asString(slot.getOutputSides()));
            if (slot.isReadOnly()) {
                tooltip.add("Output Only Tank");
            }
            tooltip.add("Accepts: " + (slot.getValidator() == null ? "Any Item" : slot.getValidator().getTooltip()));
            return;
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (this.isTankValid()) {
            int percentage = (int)(100.0 * (double)this.getTank().getAmount() / (double)this.getTankCapacity());
            tooltip.add(this.getTank().getName());
            tooltip.add(percentage + "% full");
            tooltip.add((int)this.getTank().getAmount() + " mB");
            return;
        }
        tooltip.add("Empty");
    }

    private TankSlot getTankSlot() {
        ITankMachine tank = Machine.getInterface(ITankMachine.class, ((Window)Window.get(this)).getInventory());
        return tank != null ? tank.getTankSlot(this.tankID) : null;
    }
}

