/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IErrorStateSource;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.PowerInfo;
import binnie.core.machines.power.ProcessInfo;
import binnie.core.machines.power.TankInfo;
import binnie.core.machines.transfer.TransferRequest;
import binnie.core.network.packet.MessageContainerUpdate;
import binnie.craftgui.minecraft.ControlSlot;
import binnie.craftgui.minecraft.CustomSlot;
import binnie.craftgui.minecraft.EnumHighlighting;
import binnie.craftgui.minecraft.IWindowAffectsShiftClick;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.minecraft.WindowInventory;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ContainerCraftGUI
extends Container {
    Window window;
    Map<String, NBTTagCompound> syncedNBT = new HashMap<String, NBTTagCompound>();
    Map<String, NBTTagCompound> sentNBT = new HashMap<String, NBTTagCompound>();
    private Map<Integer, TankInfo> syncedTanks = new HashMap<Integer, TankInfo>();
    private PowerInfo syncedPower = new PowerInfo();
    private ProcessInfo syncedProcess = new ProcessInfo();
    private int errorType = 0;
    private ErrorState error = null;
    int mousedOverSlotNumber = -1;

    private Side getSide() {
        return this.window.isServer() ? Side.SERVER : Side.CLIENT;
    }

    public Slot func_75139_a(int par1) {
        if (par1 < 0 || par1 >= this.field_75151_b.size()) {
            return null;
        }
        return (Slot)this.field_75151_b.get(par1);
    }

    public void func_75141_a(int par1, ItemStack par2ItemStack) {
        if (this.func_75139_a(par1) != null) {
            this.func_75139_a(par1).func_75215_d(par2ItemStack);
        }
    }

    public void func_75131_a(ItemStack[] par1ArrayOfItemStack) {
        for (int i = 0; i < par1ArrayOfItemStack.length; ++i) {
            if (this.func_75139_a(i) == null) continue;
            this.func_75139_a(i).func_75215_d(par1ArrayOfItemStack[i]);
        }
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        WindowInventory inventory = this.window.getWindowInventory();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || (stack = new TransferRequest(stack, (IInventory)par1EntityPlayer.field_71071_by).transfer(true)) == null) continue;
            par1EntityPlayer.func_71019_a(stack, false);
        }
    }

    public ItemStack func_75144_a(int slotNum, int mouseButton, int modifier, EntityPlayer player) {
        Slot slot = this.func_75139_a(slotNum);
        if (slot instanceof CustomSlot && ((CustomSlot)slot).handleClick()) {
            ((CustomSlot)slot).onSlotClick(this, mouseButton, modifier, player);
            return player.field_71071_by.func_70445_o();
        }
        return super.func_75144_a(slotNum, mouseButton, modifier, player);
    }

    public ContainerCraftGUI(Window window) {
        GameProfile user;
        this.window = window;
        IMachine machine = Machine.getMachine(window.getInventory());
        if (this.getSide() == Side.SERVER && machine != null && (user = machine.getOwner()) != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("username", user.getName());
            this.sendNBTToClient("username", nbt);
        }
    }

    public void sendNBTToClient(String key, NBTTagCompound nbt) {
        this.syncedNBT.put(key, nbt);
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    public void newSlot(Slot slot) {
        this.func_75146_a(slot);
    }

    public final ItemStack func_82846_b(EntityPlayer player, int slotID) {
        return this.shiftClick(player, slotID);
    }

    private ItemStack shiftClick(EntityPlayer player, int slotnumber) {
        TransferRequest request = this.getShiftClickRequest(player, slotnumber);
        if (request == null) {
            return null;
        }
        ItemStack itemstack = request.transfer(true);
        Slot shiftClickedSlot = (Slot)this.field_75151_b.get(slotnumber);
        shiftClickedSlot.func_75215_d(itemstack);
        shiftClickedSlot.func_75218_e();
        return null;
    }

    private TransferRequest getShiftClickRequest(EntityPlayer player, int slotnumber) {
        if (slotnumber < 0) {
            return null;
        }
        Slot shiftClickedSlot = (Slot)this.field_75151_b.get(slotnumber);
        ItemStack itemstack = null;
        if (shiftClickedSlot.func_75216_d()) {
            itemstack = shiftClickedSlot.func_75211_c().func_77946_l();
        }
        InventoryPlayer playerInventory = player.field_71071_by;
        IInventory containerInventory = this.window.getInventory();
        WindowInventory windowInventory = this.window.getWindowInventory();
        if (containerInventory == null) {
            return null;
        }
        int[] target = new int[36];
        for (int i = 0; i < 36; ++i) {
            target[i] = i;
        }
        TransferRequest request = shiftClickedSlot.field_75224_c == playerInventory ? new TransferRequest(itemstack, containerInventory).setOrigin(shiftClickedSlot.field_75224_c) : new TransferRequest(itemstack, (IInventory)playerInventory).setOrigin(shiftClickedSlot.field_75224_c).setTargetSlots(target);
        if (this.window instanceof IWindowAffectsShiftClick) {
            ((IWindowAffectsShiftClick)((Object)this.window)).alterRequest(request);
        }
        return request;
    }

    public final ItemStack tankClick(EntityPlayer player, int slotID) {
        if (player.field_71071_by.func_70445_o() == null) {
            return null;
        }
        ItemStack heldItem = player.field_71071_by.func_70445_o().func_77946_l();
        heldItem = new TransferRequest(heldItem, this.window.getInventory()).setOrigin((IInventory)player.field_71071_by).setTargetSlots(new int[0]).setTargetTanks(new int[]{slotID}).transfer(true);
        player.field_71071_by.func_70437_b(heldItem);
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_71113_k();
        }
        return heldItem;
    }

    public boolean handleNBT(Side side, EntityPlayer player, String name, NBTTagCompound action) {
        if (side == Side.SERVER && name.equals("tank-click")) {
            this.tankClick(player, action.func_74771_c("id"));
        }
        if (name.contains("tank-update")) {
            this.onTankUpdate(action);
        } else if (name.equals("power-update")) {
            this.onPowerUpdate(action);
        } else if (name.equals("process-update")) {
            this.onProcessUpdate(action);
        } else if (name.equals("error-update")) {
            this.onErrorUpdate(action);
        } else if (name.equals("mouse-over-slot")) {
            this.onMouseOverSlot(player, action);
        } else if (name.equals("shift-click-info")) {
            this.onRecieveShiftClickHighlights(player, action);
        }
        return false;
    }

    public void func_75142_b() {
        INetwork.SendGuiNBT machineSync;
        super.func_75142_b();
        if (this.getSide() == Side.SERVER) {
            this.window.onUpdate();
        }
        ITankMachine tanks = Machine.getInterface(ITankMachine.class, this.window.getInventory());
        IPoweredMachine powered = Machine.getInterface(IPoweredMachine.class, this.window.getInventory());
        IErrorStateSource error = Machine.getInterface(IErrorStateSource.class, this.window.getInventory());
        IProcess process = Machine.getInterface(IProcess.class, this.window.getInventory());
        if (tanks != null && this.window.isServer()) {
            for (int i = 0; i < tanks.getTankInfos().length; ++i) {
                TankInfo tank = tanks.getTankInfos()[i];
                if (this.getTankInfo(i).equals(tank)) continue;
                this.syncedNBT.put("tank-update-" + i, this.createTankNBT(i, tank));
                this.syncedTanks.put(i, tank);
            }
        }
        if (powered != null && this.window.isServer()) {
            this.syncedNBT.put("power-update", this.createPowerNBT(powered.getPowerInfo()));
        }
        if (process != null && this.window.isServer()) {
            this.syncedNBT.put("process-update", this.createProcessNBT(process.getInfo()));
        }
        if (error != null && this.window.isServer()) {
            this.syncedNBT.put("error-update", this.createErrorNBT(error));
        }
        if ((machineSync = Machine.getInterface(INetwork.SendGuiNBT.class, this.window.getInventory())) != null) {
            machineSync.sendGuiNBT(this.syncedNBT);
        }
        HashMap<String, NBTTagCompound> sentThisTime = new HashMap<String, NBTTagCompound>();
        for (Map.Entry<String, NBTTagCompound> nbt : this.syncedNBT.entrySet()) {
            nbt.getValue().func_74778_a("type", nbt.getKey());
            boolean shouldSend = true;
            NBTTagCompound lastSent = this.sentNBT.get(nbt.getKey());
            if (lastSent != null) {
                boolean bl = shouldSend = !lastSent.equals((Object)nbt.getValue());
            }
            if (!shouldSend) continue;
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                if (!(this.field_75149_d.get(j) instanceof EntityPlayerMP)) continue;
                EntityPlayerMP player = (EntityPlayerMP)this.field_75149_d.get(j);
                BinnieCore.proxy.sendToPlayer(new MessageContainerUpdate(nbt.getValue()), (EntityPlayer)player);
            }
            sentThisTime.put(nbt.getKey(), nbt.getValue());
        }
        this.sentNBT.putAll(sentThisTime);
        this.syncedNBT.clear();
    }

    private NBTTagCompound createErrorNBT(IErrorStateSource error) {
        NBTTagCompound nbt = new NBTTagCompound();
        ErrorState state = null;
        if (error.canWork() != null) {
            nbt.func_74774_a("type", (byte)0);
            state = error.canWork();
        } else if (error.canProgress() != null) {
            nbt.func_74774_a("type", (byte)1);
            state = error.canProgress();
        }
        if (state != null) {
            state.writeToNBT(nbt);
        }
        return nbt;
    }

    public NBTTagCompound createPowerNBT(PowerInfo powerInfo) {
        NBTTagCompound nbt = new NBTTagCompound();
        powerInfo.writeToNBT(nbt);
        return nbt;
    }

    public NBTTagCompound createProcessNBT(ProcessInfo powerInfo) {
        NBTTagCompound nbt = new NBTTagCompound();
        powerInfo.writeToNBT(nbt);
        return nbt;
    }

    public NBTTagCompound createTankNBT(int tank, TankInfo tankInfo) {
        NBTTagCompound nbt = new NBTTagCompound();
        tankInfo.writeToNBT(nbt);
        nbt.func_74774_a("tank", (byte)tank);
        return nbt;
    }

    public void onTankUpdate(NBTTagCompound nbt) {
        byte tankID = nbt.func_74771_c("tank");
        TankInfo tank = new TankInfo();
        tank.readFromNBT(nbt);
        this.syncedTanks.put(Integer.valueOf(tankID), tank);
    }

    public void onProcessUpdate(NBTTagCompound nbt) {
        this.syncedProcess = new ProcessInfo();
        this.syncedProcess.readFromNBT(nbt);
    }

    public void onPowerUpdate(NBTTagCompound nbt) {
        this.syncedPower = new PowerInfo();
        this.syncedPower.readFromNBT(nbt);
    }

    public PowerInfo getPowerInfo() {
        return this.syncedPower;
    }

    public ProcessInfo getProcessInfo() {
        return this.syncedProcess;
    }

    public TankInfo getTankInfo(int tank) {
        return this.syncedTanks.containsKey(tank) ? this.syncedTanks.get(tank) : new TankInfo();
    }

    public void onErrorUpdate(NBTTagCompound nbt) {
        this.errorType = nbt.func_74771_c("type");
        if (nbt.func_74764_b("name")) {
            this.error = new ErrorState("", "");
            this.error.readFromNBT(nbt);
        } else {
            this.error = null;
        }
    }

    public ErrorState getErrorState() {
        return this.error;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public CustomSlot[] getCustomSlots() {
        ArrayList<CustomSlot> slots = new ArrayList<CustomSlot>();
        for (Object object : this.field_75151_b) {
            if (!(object instanceof CustomSlot)) continue;
            slots.add((CustomSlot)((Object)object));
        }
        return slots.toArray(new CustomSlot[0]);
    }

    public void setMouseOverSlot(Slot slot) {
        if (slot.field_75222_d != this.mousedOverSlotNumber) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74777_a("slot", (short)slot.field_75222_d);
            this.window.sendClientAction("mouse-over-slot", nbt);
        }
    }

    private void onMouseOverSlot(EntityPlayer player, NBTTagCompound data) {
        short slotnumber = data.func_74765_d("slot");
        TransferRequest request = this.getShiftClickRequest(player, slotnumber);
        if (request == null) {
            return;
        }
        request.transfer(false);
        NBTTagCompound nbt = new NBTTagCompound();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (TransferRequest.TransferSlot tslot : request.getInsertedSlots()) {
            CustomSlot slot = this.getSlot(tslot.inventory, tslot.id);
            if (slot == null) continue;
            slots.add(slot.field_75222_d);
        }
        int[] array = new int[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            array[i] = (Integer)slots.get(i);
        }
        nbt.func_74783_a("slots", array);
        nbt.func_74777_a("origin", slotnumber);
        this.syncedNBT.put("shift-click-info", nbt);
    }

    private void onRecieveShiftClickHighlights(EntityPlayer player, NBTTagCompound data) {
        ControlSlot.highlighting.get((Object)EnumHighlighting.ShiftClick).clear();
        ControlSlot.highlighting.get((Object)EnumHighlighting.ShiftClick).add(Integer.valueOf(data.func_74765_d("origin")));
        for (int slotnumber : data.func_74759_k("slots")) {
            ControlSlot.highlighting.get((Object)EnumHighlighting.ShiftClick).add(slotnumber);
        }
    }

    private CustomSlot getSlot(IInventory inventory, int id) {
        for (Object o : this.field_75151_b) {
            CustomSlot slot = (CustomSlot)((Object)o);
            if (slot.field_75224_c != inventory || slot.slotID != id) continue;
            return slot;
        }
        return null;
    }

    public void recieveNBT(Side side, EntityPlayer player, NBTTagCompound action) {
        String name = action.func_74779_i("type");
        if (this.handleNBT(side, player, name, action)) {
            return;
        }
        this.window.recieveGuiNBT(this.getSide(), player, name, action);
        INetwork.RecieveGuiNBT machine = Machine.getInterface(INetwork.RecieveGuiNBT.class, this.window.getInventory());
        if (machine != null) {
            machine.recieveGuiNBT(this.getSide(), player, name, action);
        }
    }
}

