/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.kitchen;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventWidget;
import binnie.craftgui.extratrees.kitchen.ControlFluidDisplay;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import net.minecraftforge.fluids.FluidStack;

public class ControlSlotFluid
extends Control
implements ITooltip {
    ControlFluidDisplay itemDisplay;
    FluidStack fluidStack;

    public ControlSlotFluid(IWidget parent, int x, int y, FluidStack fluid) {
        this(parent, x, y, 18, fluid);
    }

    public ControlSlotFluid(IWidget parent, int x, int y, int size, FluidStack fluid) {
        super(parent, x, y, size, size);
        this.addAttribute(Attribute.MouseOver);
        this.itemDisplay = new ControlFluidDisplay(this, 1, 1, size - 2);
        this.fluidStack = fluid;
        this.addSelfEventHandler((EventHandler)new EventWidget.ChangeSize.Handler(){

            @Override
            public void onEvent(EventWidget.ChangeSize event) {
                if (ControlSlotFluid.this.itemDisplay != null) {
                    ControlSlotFluid.this.itemDisplay.setSize(ControlSlotFluid.this.getSize().sub(new Vector2f(2.0f, 2.0f)));
                }
            }
        });
    }

    @Override
    public void onRenderBackground() {
        int size = (int)this.getSize().x();
        this.getRenderer().renderTexture((Object)CraftGUITexture.Slot, this.getArea());
        if (this.getSuperParent().getMousedOverWidget() == this) {
            this.getRenderer().renderGradientRect(new Area(new Vector2f(1.0f, 1.0f), this.getArea().size().sub(new Vector2f(2.0f, 2.0f))), -2130706433, -2130706433);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.itemDisplay.setItemStack(this.getFluidStack());
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        FluidStack item = this.getFluidStack();
        if (item == null) {
            return;
        }
        tooltip.add(item.getFluid().getLocalizedName());
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }
}

