/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.dictionary;

import binnie.Binnie;
import binnie.core.IBinnieMod;
import binnie.core.genetics.TreeBreedingSystem;
import binnie.craftgui.controls.listbox.ControlList;
import binnie.craftgui.controls.listbox.ControlListBox;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.extratrees.dictionary.PageFruit;
import binnie.craftgui.extratrees.dictionary.PagePlanksOverview;
import binnie.craftgui.extratrees.dictionary.PagePlanksTrees;
import binnie.craftgui.extratrees.dictionary.PageSpeciesTreeGenome;
import binnie.craftgui.extratrees.dictionary.PageWood;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.mod.database.ControlItemStackOption;
import binnie.craftgui.mod.database.DatabaseTab;
import binnie.craftgui.mod.database.IDatabaseMode;
import binnie.craftgui.mod.database.PageBranchOverview;
import binnie.craftgui.mod.database.PageBranchSpecies;
import binnie.craftgui.mod.database.PageBreeder;
import binnie.craftgui.mod.database.PageSpeciesClassification;
import binnie.craftgui.mod.database.PageSpeciesMutations;
import binnie.craftgui.mod.database.PageSpeciesOverview;
import binnie.craftgui.mod.database.PageSpeciesResultant;
import binnie.craftgui.mod.database.WindowAbstractDatabase;
import binnie.extratrees.ExtraTrees;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class WindowTreeDictionary
extends WindowAbstractDatabase {
    ControlListBox<ItemStack> selectionBoxFruit;
    ControlListBox<ItemStack> selectionBoxWood;
    ControlListBox<ItemStack> selectionBoxPlanks;

    public WindowTreeDictionary(EntityPlayer player, Side side, boolean nei) {
        super(player, side, nei, Binnie.Genetics.treeBreedingSystem, 120.0f);
    }

    public static Window create(EntityPlayer player, Side side, boolean nei) {
        return new WindowTreeDictionary(player, side, nei);
    }

    @Override
    protected void addTabs() {
        this.getInfoPages(WindowAbstractDatabase.Mode.Species).addChild(new PageSpeciesOverview(this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab("Overview", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Species).addChild(new PageSpeciesTreeGenome(this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab("Genome", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Species).addChild(new PageSpeciesClassification(this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab("Classification", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Species).addChild(new PageSpeciesResultant(this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab("Resultant Mutations", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Species).addChild(new PageSpeciesMutations(this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab("Further Muations", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Branches).addChild(new PageBranchOverview(this.getInfoPages(WindowAbstractDatabase.Mode.Branches), new DatabaseTab("Overview", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Branches).addChild(new PageBranchSpecies(this.getInfoPages(WindowAbstractDatabase.Mode.Branches), new DatabaseTab("Species", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Breeder).addChild(new PageBreeder(this.getInfoPages(WindowAbstractDatabase.Mode.Breeder), this.getUsername(), new DatabaseTab("Breeder", 0)));
        this.createMode(TreeMode.Fruit, new WindowAbstractDatabase.ModeWidgets(TreeMode.Fruit, this){

            @Override
            public void createListBox(IArea area) {
                this.listBox = new ControlListBox<ItemStack>((IWidget)this.modePage, area.x(), area.y(), area.w(), area.h(), 12.0f){

                    @Override
                    public IWidget createOption(ItemStack value, int y) {
                        return new ControlItemStackOption((ControlList)this.getContent(), value, y);
                    }
                };
                this.listBox.setOptions(((TreeBreedingSystem)WindowTreeDictionary.this.getBreedingSystem()).allFruits);
            }
        });
        this.createMode(TreeMode.Wood, new WindowAbstractDatabase.ModeWidgets(TreeMode.Wood, this){

            @Override
            public void createListBox(IArea area) {
                this.listBox = new ControlListBox<ItemStack>((IWidget)this.modePage, area.x(), area.y(), area.w(), area.h(), 12.0f){

                    @Override
                    public IWidget createOption(ItemStack value, int y) {
                        return new ControlItemStackOption((ControlList)this.getContent(), value, y);
                    }
                };
                this.listBox.setOptions(((TreeBreedingSystem)WindowTreeDictionary.this.getBreedingSystem()).allWoods);
            }
        });
        this.createMode(TreeMode.Planks, new WindowAbstractDatabase.ModeWidgets(TreeMode.Planks, this){

            @Override
            public void createListBox(IArea area) {
                this.listBox = new ControlListBox<ItemStack>((IWidget)this.modePage, area.x(), area.y(), area.w(), area.h(), 12.0f){

                    @Override
                    public IWidget createOption(ItemStack value, int y) {
                        return new ControlItemStackOption((ControlList)this.getContent(), value, y);
                    }
                };
                this.listBox.setOptions(((TreeBreedingSystem)WindowTreeDictionary.this.getBreedingSystem()).allPlanks);
            }
        });
        this.getInfoPages(TreeMode.Fruit).addChild(new PageFruit(this.getInfoPages(TreeMode.Fruit), new DatabaseTab("Natural Trees", 0, "List of trees that naturally produce this fruit"), true));
        this.getInfoPages(TreeMode.Fruit).addChild(new PageFruit(this.getInfoPages(TreeMode.Fruit), new DatabaseTab("Tolerable Trees", 0, "List of trees that can produce this fruit if they possess the right allele"), false));
        this.getInfoPages(TreeMode.Wood).addChild(new PageWood(this.getInfoPages(TreeMode.Wood), new DatabaseTab("Natural Trees", 0, "List of trees that are made of this wood")));
        this.getInfoPages(TreeMode.Planks).addChild(new PagePlanksOverview(this.getInfoPages(TreeMode.Planks), new DatabaseTab("Overview", 0, "Description and possible uses")));
        this.getInfoPages(TreeMode.Planks).addChild(new PagePlanksTrees(this.getInfoPages(TreeMode.Planks), new DatabaseTab("Natural Trees", 1, "List of trees that produce logs that can be crafted into this plank")));
    }

    @Override
    protected IBinnieMod getMod() {
        return ExtraTrees.instance;
    }

    @Override
    protected String getName() {
        return "TreeDatabase";
    }

    static enum TreeMode implements IDatabaseMode
    {
        Fruit,
        Wood,
        Planks;

    }
}

