/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.dictionary;

import binnie.core.IBinnieMod;
import binnie.core.machines.Machine;
import binnie.core.machines.power.ErrorState;
import binnie.craftgui.core.geometry.Direction;
import binnie.craftgui.extratrees.dictionary.ControlFruitPressProgress;
import binnie.craftgui.minecraft.ControlEnergyBar;
import binnie.craftgui.minecraft.ControlErrorState;
import binnie.craftgui.minecraft.ControlLiquidTank;
import binnie.craftgui.minecraft.ControlPlayerInventory;
import binnie.craftgui.minecraft.ControlSlot;
import binnie.craftgui.minecraft.CustomSlot;
import binnie.craftgui.minecraft.Window;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.machines.Press;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public class WindowPress
extends Window {
    public WindowPress(EntityPlayer player, IInventory inventory, Side side) {
        super(194.0f, 192.0f, player, inventory, side);
    }

    @Override
    protected IBinnieMod getMod() {
        return ExtraTrees.instance;
    }

    @Override
    protected String getName() {
        return "Press";
    }

    @Override
    public void initialize() {
        this.setTitle("Press");
        new ControlSlot(this, 24.0f, 52.0f).create(this.getInventory(), Press.slotFruit);
        new ControlLiquidTank(this, 99, 32).setTankID(Press.tankWater);
        new ControlEnergyBar(this, 154, 32, 16, 60, Direction.Upwards);
        new ControlPlayerInventory(this);
        new ControlErrorState(this, 128.0f, 54.0f);
        new ControlFruitPressProgress(this, 62.0f, 24.0f);
        ((Window)this.getSuperParent()).getContainer().newSlot(new CustomSlot(this.getInventory(), Press.slotCurrent, 0, 0));
    }

    public static Window create(EntityPlayer player, IInventory inventory, Side side) {
        return new WindowPress(player, inventory, side);
    }

    @Override
    public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound action) {
        Press.ComponentFruitPressLogic logic = Machine.getInterface(Press.ComponentFruitPressLogic.class, this.getInventory());
        super.recieveGuiNBT(side, player, name, action);
        if (side == Side.SERVER && name.equals("fruitpress-click")) {
            if (logic.canWork() == null && (logic.canProgress() == null || logic.canProgress() instanceof ErrorState.InsufficientPower)) {
                logic.alterProgress(2.0f);
            } else if (side == Side.SERVER && name.equals("clear-fruit")) {
                logic.setProgress(0.0f);
                this.getInventory().func_70299_a(Press.slotCurrent, null);
            }
        }
    }
}

