/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.core.geometry;

import binnie.craftgui.controls.core.IControlValue;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPosition;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventValueChanged;

public class CraftGUIUtil {
    public static void alignToWidget(IWidget target, IWidget relativeTo) {
        IPosition startPos = target.getAbsolutePosition();
        IPosition endPos = relativeTo.getAbsolutePosition();
        CraftGUIUtil.moveWidget(target, endPos.sub(startPos));
    }

    public static void moveWidget(IWidget target, IPosition movement) {
        target.setPosition(target.getPosition().add(movement));
    }

    public static IArea getPaddedArea(IArea area, int padding) {
        if ((float)(padding * 2) < area.size().x() && (float)(padding * 2) < area.size().y()) {
            return new Area(new Vector2f(area.pos().x() + (float)padding, area.pos().y() + (float)padding), area.size().sub(new Vector2f(padding * 2, padding * 2)));
        }
        return area;
    }

    public static void horizontalGrid(float px, float py, IWidget ... widgets) {
        CraftGUIUtil.horizontalGrid(px, py, TextJustification.MiddleCenter, 0.0f, widgets);
    }

    public static void horizontalGrid(float px, float py, TextJustification just, float spacing, IWidget ... widgets) {
        float x = 0.0f;
        float h = 0.0f;
        for (IWidget widget : widgets) {
            h = Math.max(h, widget.getSize().y());
        }
        for (IWidget widget : widgets) {
            widget.setPosition(new Vector2f(px + x, py + (h - widget.getSize().y()) * just.yOffset));
            x += widget.getSize().x() + spacing;
        }
    }

    public static void verticalGrid(float px, float py, IWidget ... widgets) {
        CraftGUIUtil.horizontalGrid(px, py, TextJustification.MiddleCenter, 0.0f, widgets);
    }

    public static void verticalGrid(float px, float py, TextJustification just, float spacing, IWidget ... widgets) {
        float y = 0.0f;
        float w = 0.0f;
        for (IWidget widget : widgets) {
            w = Math.max(w, widget.getSize().x());
        }
        for (IWidget widget : widgets) {
            widget.setPosition(new Vector2f(px + (w - widget.getSize().x()) * just.xOffset, py + y));
            y += widget.getSize().y() + spacing;
        }
    }

    public static <T> void linkWidgets(final IControlValue<T> tab, final IControlValue<T> target) {
        tab.addSelfEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                target.setValue(event.getValue());
            }
        });
        target.addSelfEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                tab.setValue(event.getValue());
            }
        });
    }
}

