/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.core;

import binnie.craftgui.core.ITopLevelWidget;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Widget;
import binnie.craftgui.core.geometry.IPosition;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.core.renderer.IRenderer;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.EventWidget;
import binnie.craftgui.resource.ITexture;
import org.lwjgl.input.Mouse;

public abstract class TopLevelWidget
extends Widget
implements ITopLevelWidget {
    IWidget mousedOverWidget = null;
    IWidget draggedWidget = null;
    IWidget focusedWidget = null;
    protected IPosition mousePosition = new Vector2f(0.0f, 0.0f);
    IRenderer renderer;
    IPosition dragStart = Vector2f.ZERO;

    public TopLevelWidget() {
        super(null);
        this.addEventHandler((EventHandler)new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                TopLevelWidget.this.setDraggedWidget(TopLevelWidget.this.mousedOverWidget, event.getButton());
                TopLevelWidget.this.setFocusedWidget(TopLevelWidget.this.mousedOverWidget);
            }
        });
        this.addEventHandler((EventHandler)new EventMouse.Up.Handler(){

            @Override
            public void onEvent(EventMouse.Up event) {
                TopLevelWidget.this.setDraggedWidget(null);
            }
        });
        this.addEventHandler((EventHandler)new EventWidget.StartDrag.Handler(){

            @Override
            public void onEvent(EventWidget.StartDrag event) {
                TopLevelWidget.this.dragStart = TopLevelWidget.this.getRelativeMousePosition();
            }
        });
    }

    public void setMousedOverWidget(IWidget widget) {
        if (this.mousedOverWidget == widget) {
            return;
        }
        if (this.mousedOverWidget != null) {
            this.callEvent(new EventWidget.EndMouseOver(this.mousedOverWidget));
        }
        this.mousedOverWidget = widget;
        if (this.mousedOverWidget != null) {
            this.callEvent(new EventWidget.StartMouseOver(this.mousedOverWidget));
        }
    }

    public void setDraggedWidget(IWidget widget) {
        this.setDraggedWidget(widget, -1);
    }

    public void setDraggedWidget(IWidget widget, int button) {
        if (this.draggedWidget == widget) {
            return;
        }
        if (this.draggedWidget != null) {
            this.callEvent(new EventWidget.EndDrag(this.draggedWidget));
        }
        this.draggedWidget = widget;
        if (this.draggedWidget != null) {
            this.callEvent(new EventWidget.StartDrag(this.draggedWidget, button));
        }
    }

    public void setFocusedWidget(IWidget widget) {
        IWidget newWidget = widget;
        if (this.focusedWidget == newWidget) {
            return;
        }
        if (newWidget != null && !newWidget.canFocus()) {
            newWidget = null;
        }
        if (this.focusedWidget != null) {
            this.callEvent(new EventWidget.LoseFocus(this.focusedWidget));
        }
        this.focusedWidget = newWidget;
        if (this.focusedWidget != null) {
            this.callEvent(new EventWidget.GainFocus(this.focusedWidget));
        }
    }

    @Override
    public IWidget getMousedOverWidget() {
        return this.mousedOverWidget;
    }

    @Override
    public IWidget getDraggedWidget() {
        return this.draggedWidget;
    }

    @Override
    public IWidget getFocusedWidget() {
        return this.focusedWidget;
    }

    @Override
    public boolean isMouseOver(IWidget widget) {
        return this.getMousedOverWidget() == widget;
    }

    @Override
    public boolean isDragged(IWidget widget) {
        return this.getDraggedWidget() == widget;
    }

    @Override
    public boolean isFocused(IWidget widget) {
        return this.getFocusedWidget() == widget;
    }

    @Override
    public void updateTopLevel() {
        this.setMousedOverWidget(super.calculateMousedOverWidget());
        if (!Mouse.isButtonDown((int)0) && this.draggedWidget != null) {
            this.setDraggedWidget(null);
        }
    }

    @Override
    public void setMousePosition(int x, int y) {
        float dx = (float)x - this.mousePosition.x();
        float dy = (float)y - this.mousePosition.y();
        if (dx != 0.0f || dy != 0.0f) {
            if (this.getDraggedWidget() != null) {
                this.callEvent(new EventMouse.Drag(this.getDraggedWidget(), dx, dy));
            } else {
                this.callEvent(new EventMouse.Move(this, dx, dy));
            }
        }
        this.mousePosition = new Vector2f(x, y);
        this.setMousedOverWidget(this.calculateMousedOverWidget());
    }

    @Override
    public IPosition getAbsoluteMousePosition() {
        return this.mousePosition;
    }

    @Override
    public void setRenderer(IRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public <T> T getTopLevelRenderer(Class<T> renderer) {
        if (this.renderer == null) {
            return null;
        }
        return this.renderer.subRenderer(renderer);
    }

    @Override
    public void widgetDeleted(IWidget widget) {
        if (this.isMouseOver(widget)) {
            this.setMousedOverWidget(null);
        }
        if (this.isDragged(widget)) {
            this.setDraggedWidget(null);
        }
        if (this.isFocused(widget)) {
            this.setFocusedWidget(null);
        }
    }

    @Override
    public abstract ITexture getTexture(Object var1);

    @Override
    public float getTextWidth(String text) {
        if (this.getRenderer(IRenderer.class) != null) {
            return this.getRenderer(IRenderer.class).getTextWidth(text);
        }
        return 0.0f;
    }

    @Override
    public float getTextHeight() {
        if (this.getRenderer(IRenderer.class) != null) {
            return this.getRenderer(IRenderer.class).getTextHeight();
        }
        return 0.0f;
    }

    @Override
    public float getTextHeight(String text, float width) {
        if (this.getRenderer(IRenderer.class) != null) {
            return this.getRenderer(IRenderer.class).getTextHeight(text, width);
        }
        return 0.0f;
    }

    @Override
    public IPosition getDragDistance() {
        return this.getRelativeMousePosition().sub(this.dragStart);
    }
}

