/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.tab;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.core.IControlValue;
import binnie.craftgui.controls.tab.ControlTab;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Position;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventValueChanged;
import java.util.Collection;

public class ControlTabBar<T>
extends Control
implements IControlValue<T> {
    T value;
    Position position;

    public ControlTabBar(IWidget parent, float x, float y, float width, float height, Position position) {
        super(parent, x, y, width, height);
        this.position = position;
        this.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                ControlTabBar.this.setValue(event.getValue());
            }
        }.setOrigin(EventHandler.Origin.DirectChild, this));
    }

    public void setValues(Collection<T> values) {
        int i = 0;
        while (i < this.getWidgets().size()) {
            this.deleteChild(this.getWidgets().get(0));
        }
        float length = values.size();
        int tabDimension = (int)(this.getSize().y() / length);
        int i2 = 0;
        for (T value : values) {
            ControlTab<T> tab = this.position == Position.Top || this.position == Position.Bottom ? this.createTab(i2 * tabDimension, 0.0f, tabDimension, this.getSize().y(), value) : this.createTab(0.0f, i2 * tabDimension, this.getSize().x(), tabDimension, value);
            ++i2;
        }
        if (this.value == null && !values.isEmpty()) {
            this.setValue(values.iterator().next());
        }
    }

    public ControlTab<T> createTab(float x, float y, float w, float h, T value) {
        return new ControlTab<T>(this, x, y, w, h, value);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        boolean change = this.value != value;
        this.value = value;
        if (change) {
            this.callEvent(new EventValueChanged<T>(this, value));
        }
    }

    public Position getDirection() {
        return this.position;
    }
}

