/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.scroll;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.scroll.ControlScroll;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventMouse;

public class ControlScrollBar
extends Control {
    final ControlScroll parent;
    float maxHeight = 0.0f;

    public ControlScrollBar(final ControlScroll parent) {
        super(parent, 0.0f, 0.0f, parent.getSize().x(), parent.getSize().y());
        this.maxHeight = parent.getSize().y();
        this.parent = parent;
        this.addAttribute(Attribute.MouseOver);
        this.addSelfEventHandler((EventHandler)new EventMouse.Drag.Handler(){

            @Override
            public void onEvent(EventMouse.Drag event) {
                parent.getScrollableWidget().movePercentage(event.getDy() / ControlScrollBar.this.maxHeight);
            }
        });
    }

    @Override
    public void onUpdate() {
        float yOffset = this.maxHeight * this.parent.getScrollableWidget().getPercentageIndex();
        this.setOffset(new Vector2f(0.0f, yOffset));
    }

    @Override
    public boolean isEnabled() {
        return this.parent.getScrollableWidget().getPercentageShown() < 0.99f;
    }

    public float getBarHeight() {
        return this.maxHeight * this.parent.getScrollableWidget().getPercentageShown();
    }
}

