/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.page;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.core.IControlValue;
import binnie.craftgui.controls.core.IControlValues;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.events.EventValueChanged;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ControlPages<T>
extends Control
implements IControlValues<T>,
IControlValue<T> {
    Map<T, IControlValue<T>> pages = new LinkedHashMap<T, IControlValue<T>>();
    T value = null;

    @Override
    public boolean isChildVisible(IWidget child) {
        if (child == null) {
            return false;
        }
        return this.pages.get(this.getValue()) == child;
    }

    public ControlPages(IWidget parent, float x, float y, float w, float h) {
        super(parent, x, y, w, h);
    }

    public void addChild(IControlValue<T> page) {
        this.pages.put(page.getValue(), page);
        if (this.getValue() == null) {
            this.setValue(page.getValue());
        }
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        if (this.value != value) {
            this.value = value;
            this.callEvent(new EventValueChanged<T>(this, value));
        }
    }

    @Override
    public Collection<T> getValues() {
        return this.pages.keySet();
    }

    @Override
    public void setValues(Collection<T> values) {
    }

    public Collection<IControlValue<T>> getPages() {
        return this.pages.values();
    }
}

