/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.listbox;

import binnie.core.util.IValidator;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.core.IControlValue;
import binnie.craftgui.controls.listbox.ControlListBox;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventValueChanged;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ControlList<T>
extends Control
implements IControlValue<T> {
    ControlListBox<T> parent;
    T value = null;
    Map<T, IWidget> allOptions = new LinkedHashMap<T, IWidget>();
    Map<T, IWidget> optionWidgets = new LinkedHashMap<T, IWidget>();
    boolean creating = false;
    IValidator<IWidget> validator;

    protected ControlList(ControlListBox<T> parent, float x, float y, float w, float h) {
        super(parent, x, y, w, h);
        this.parent = parent;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        if (value == this.value) {
            return;
        }
        this.value = value;
        if (value != null && this.optionWidgets.containsKey(value)) {
            float top = this.optionWidgets.get(value).pos().y();
            float bottom = this.optionWidgets.get(value).pos().y() + this.optionWidgets.get(value).size().y();
            if (top / this.size().y() < this.parent.getPercentageIndex()) {
                this.parent.setPercentageIndex(top / this.size().y());
            }
            if (bottom / this.size().y() > this.parent.getPercentageIndex() + this.parent.getPercentageShown()) {
                this.parent.setPercentageIndex(bottom / this.size().y() - this.parent.getPercentageShown());
            }
        }
        this.getParent().callEvent(new EventValueChanged<T>(this.getParent(), value));
    }

    public void setOptions(Collection<T> options) {
        this.deleteAllChildren();
        this.allOptions.clear();
        int i = 0;
        for (T option : options) {
            IWidget optionWidget = ((ControlListBox)this.getParent()).createOption(option, 0);
            if (optionWidget != null) {
                this.allOptions.put(option, optionWidget);
            }
            ++i;
        }
        this.filterOptions();
    }

    public void filterOptions() {
        int height = 0;
        this.optionWidgets.clear();
        for (Map.Entry<T, IWidget> entry : this.allOptions.entrySet()) {
            if (this.isValidOption(entry.getValue())) {
                entry.getValue().show();
                this.optionWidgets.put(entry.getKey(), entry.getValue());
                entry.getValue().setPosition(new Vector2f(0.0f, height));
                height = (int)((float)height + entry.getValue().getSize().y());
                continue;
            }
            entry.getValue().hide();
        }
        this.creating = true;
        this.setValue(this.getValue());
        this.setSize(new Vector2f(this.getSize().x(), height));
    }

    public Collection<T> getOptions() {
        return this.optionWidgets.keySet();
    }

    public Collection<T> getAllOptions() {
        return this.allOptions.keySet();
    }

    public int getIndexOf(T value) {
        int index = 0;
        for (T option : this.getOptions()) {
            if (option.equals(value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getCurrentIndex() {
        return this.getIndexOf(this.getValue());
    }

    public void setIndex(int currentIndex) {
        int index = 0;
        for (T option : this.getOptions()) {
            if (index == currentIndex) {
                this.setValue(option);
                return;
            }
            ++index;
        }
        this.setValue(null);
    }

    private boolean isValidOption(IWidget widget) {
        return this.validator == null ? true : this.validator.isValid(widget);
    }

    public void setValidator(IValidator<IWidget> validator) {
        if (this.validator != validator) {
            this.validator = validator;
            this.filterOptions();
        }
    }
}

