/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.button;

import binnie.craftgui.controls.button.ControlButton;
import binnie.craftgui.controls.core.IControlValue;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.events.EventButtonClicked;
import binnie.craftgui.events.EventValueChanged;
import java.util.ArrayList;
import java.util.List;

public class ControlEnumButton<T>
extends ControlButton
implements IControlValue<T> {
    public static final String eventEnumChanged = "eventEnumButtonChanged";
    private T currentSelection;
    private List<T> enumConstants = new ArrayList<T>();

    @Override
    public String getText() {
        return this.currentSelection.toString();
    }

    @Override
    public void onMouseClick(EventButtonClicked event) {
        int index = this.enumConstants.indexOf(this.currentSelection);
        index = index < this.enumConstants.size() - 1 ? ++index : 0;
        T newEnum = this.enumConstants.get(index);
        this.setValue(newEnum);
    }

    @Override
    public void setValue(T selection) {
        if (this.currentSelection != selection) {
            this.currentSelection = selection;
            this.callEvent(new EventValueChanged<T>(this, this.getValue()));
        }
    }

    public ControlEnumButton(IWidget parent, float x, float y, float width, float height, T[] values) {
        super(parent, x, y, width, height, "");
        for (T value : values) {
            this.enumConstants.add(value);
        }
        if (values.length > 0) {
            this.currentSelection = values[0];
        }
    }

    @Override
    public T getValue() {
        return this.currentSelection;
    }
}

