/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls;

import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.core.IControlValue;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.CraftGUIUtil;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventKey;
import binnie.craftgui.events.EventTextEdit;
import binnie.craftgui.events.EventWidget;

public class ControlTextEdit
extends Control
implements IControlValue<String> {
    char[] allowedCharacters = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', '(', ')', '[', ']', '\'', '\"', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '!', '?'};
    ControlText text = new ControlText(this, CraftGUIUtil.getPaddedArea(this.getArea(), 2), "", TextJustification.MiddleLeft);

    public ControlTextEdit(IWidget parent, float x, float y, float width, float height) {
        super(parent, x, y, width, height);
        this.text.setColour(0);
        this.setColour(0xAAAAAA);
        this.addAttribute(Attribute.CanFocus);
        this.addAttribute(Attribute.MouseOver);
        this.addEventHandler(new EventKey.Down.Handler(){

            @Override
            public void onEvent(EventKey.Down event) {
                if (event.getKey() == 14 && ControlTextEdit.this.text.getValue().length() > 0) {
                    ControlTextEdit.this.text.setValue(ControlTextEdit.this.text.getValue().substring(0, ControlTextEdit.this.text.getValue().length() - 1));
                    ControlTextEdit.this.callEvent(new EventTextEdit(ControlTextEdit.this.getWidget(), ControlTextEdit.this.text.getValue()));
                    return;
                }
                if (event.getKey() == 211 && ControlTextEdit.this.text.getValue().length() > 0) {
                    ControlTextEdit.this.text.setValue("");
                    ControlTextEdit.this.callEvent(new EventTextEdit(ControlTextEdit.this.getWidget(), ControlTextEdit.this.text.getValue()));
                    return;
                }
                char character = event.getCharacter();
                for (char allowed : ControlTextEdit.this.allowedCharacters) {
                    if (character != allowed) continue;
                    ControlTextEdit.this.text.setValue(ControlTextEdit.this.text.getValue() + allowed);
                    ControlTextEdit.this.callEvent(new EventTextEdit(ControlTextEdit.this.getWidget(), ControlTextEdit.this.text.getValue()));
                    return;
                }
            }
        }.setOrigin(EventHandler.Origin.Self, this));
        this.addEventHandler(new EventWidget.GainFocus.Handler(){

            @Override
            public void onEvent(EventWidget.GainFocus event) {
                ControlTextEdit.this.setColour(0xFFFFFF);
                ControlTextEdit.this.text.setColour(0xFFFFFF);
            }
        }.setOrigin(EventHandler.Origin.Self, this));
        this.addEventHandler(new EventWidget.LoseFocus.Handler(){

            @Override
            public void onEvent(EventWidget.LoseFocus event) {
                ControlTextEdit.this.setColour(0xAAAAAA);
                ControlTextEdit.this.text.setColour(0);
            }
        }.setOrigin(EventHandler.Origin.Self, this));
    }

    @Override
    public String getValue() {
        return this.text.getValue();
    }

    @Override
    public void setValue(String value) {
        this.text.setValue(value);
    }
}

