/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.botany;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.botany.api.IFlowerColour;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.core.IBinnieMod;
import binnie.craftgui.botany.ControlColourOption;
import binnie.craftgui.botany.PageColourMix;
import binnie.craftgui.botany.PageColourMixResultant;
import binnie.craftgui.botany.PageSpeciesFlowerGenome;
import binnie.craftgui.controls.listbox.ControlList;
import binnie.craftgui.controls.listbox.ControlListBox;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.mod.database.DatabaseTab;
import binnie.craftgui.mod.database.IDatabaseMode;
import binnie.craftgui.mod.database.PageBranchOverview;
import binnie.craftgui.mod.database.PageBranchSpecies;
import binnie.craftgui.mod.database.PageBreeder;
import binnie.craftgui.mod.database.PageSpeciesClassification;
import binnie.craftgui.mod.database.PageSpeciesMutations;
import binnie.craftgui.mod.database.PageSpeciesOverview;
import binnie.craftgui.mod.database.PageSpeciesResultant;
import binnie.craftgui.mod.database.WindowAbstractDatabase;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;

public class WindowFlowerDictionary
extends WindowAbstractDatabase {
    ControlListBox<EnumFlowerColor> selectionBoxColors;

    public WindowFlowerDictionary(EntityPlayer player, Side side, boolean nei) {
        super(player, side, nei, Binnie.Genetics.flowerBreedingSystem, 130.0f);
    }

    public static Window create(EntityPlayer player, Side side, boolean nei) {
        return new WindowFlowerDictionary(player, side, nei);
    }

    @Override
    protected void addTabs() {
        this.getInfoPages(WindowAbstractDatabase.Mode.Species).addChild(new PageSpeciesOverview(this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab("Overview", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Species).addChild(new PageSpeciesFlowerGenome(this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab("Genome", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Species).addChild(new PageSpeciesClassification(this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab("Classification", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Species).addChild(new PageSpeciesResultant(this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab("Resultant Mutations", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Species).addChild(new PageSpeciesMutations(this.getInfoPages(WindowAbstractDatabase.Mode.Species), new DatabaseTab("Further Muations", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Branches).addChild(new PageBranchOverview(this.getInfoPages(WindowAbstractDatabase.Mode.Branches), new DatabaseTab("Overview", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Branches).addChild(new PageBranchSpecies(this.getInfoPages(WindowAbstractDatabase.Mode.Branches), new DatabaseTab("Species", 0)));
        this.createMode(FlowerMode.Color, new WindowAbstractDatabase.ModeWidgets(FlowerMode.Color, this){

            @Override
            public void createListBox(IArea area) {
                this.listBox = new ControlListBox<IFlowerColour>((IWidget)this.modePage, area.x(), area.y(), area.w(), area.h(), 12.0f){

                    @Override
                    public IWidget createOption(IFlowerColour value, int y) {
                        return new ControlColourOption((ControlList)this.getContent(), value, y);
                    }
                };
                ArrayList<EnumFlowerColor> colors = new ArrayList<EnumFlowerColor>();
                for (EnumFlowerColor c : EnumFlowerColor.values()) {
                    colors.add(c);
                }
                this.listBox.setOptions(colors);
            }
        });
        this.getInfoPages(FlowerMode.Color).addChild(new PageColourMixResultant(this.getInfoPages(FlowerMode.Color), new DatabaseTab("Resultant Mixes", 0)));
        this.getInfoPages(FlowerMode.Color).addChild(new PageColourMix(this.getInfoPages(FlowerMode.Color), new DatabaseTab("Further Mixes", 0)));
        this.getInfoPages(WindowAbstractDatabase.Mode.Breeder).addChild(new PageBreeder(this.getInfoPages(WindowAbstractDatabase.Mode.Breeder), this.getUsername(), new DatabaseTab("Breeder", 0)));
    }

    @Override
    protected IBinnieMod getMod() {
        return Botany.instance;
    }

    @Override
    protected String getName() {
        return "FlowerDatabase";
    }

    static enum FlowerMode implements IDatabaseMode
    {
        Color;

    }
}

