/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.botany;

import binnie.Binnie;
import binnie.botany.api.EnumFlowerChromosome;
import binnie.botany.api.EnumFlowerStage;
import binnie.botany.api.IAlleleFlowerSpecies;
import binnie.botany.api.IFlower;
import binnie.botany.api.IFlowerGenome;
import binnie.botany.core.BotanyCore;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.scroll.ControlScrollableContent;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.minecraft.ControlItemDisplay;
import binnie.craftgui.mod.database.DatabaseTab;
import binnie.craftgui.mod.database.PageSpecies;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import net.minecraft.item.ItemStack;

public class PageSpeciesFlowerGenome
extends PageSpecies {
    public PageSpeciesFlowerGenome(IWidget parent, DatabaseTab tab) {
        super(parent, tab);
    }

    @Override
    public void onValueChanged(IAlleleSpecies species) {
        this.deleteAllChildren();
        IAllele[] template = Binnie.Genetics.getFlowerRoot().getTemplate(species.getUID());
        if (template == null) {
            return;
        }
        IFlower tree = Binnie.Genetics.getFlowerRoot().templateAsIndividual(template);
        if (tree == null) {
            return;
        }
        IFlowerGenome genome = tree.getGenome();
        IAlleleFlowerSpecies treeSpecies = genome.getPrimary();
        int w = 144;
        int h = 176;
        new ControlText(this, new Area(0.0f, 4.0f, w, 16.0f), "Genome", TextJustification.MiddleCenter);
        ControlScrollableContent<Control> scrollable = new ControlScrollableContent<Control>(this, 4.0f, 20.0f, w - 8, h - 8 - 16, 12.0f);
        Control contents = new Control(scrollable, 0.0f, 0.0f, w - 8 - 12, h - 8 - 16);
        int tw = w - 8 - 12;
        int w1 = 55;
        int w2 = tw - 50;
        int y = 0;
        int th = 14;
        int th2 = 18;
        new ControlText(contents, new Area(0.0f, y, w1, th), "Temp. : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), treeSpecies.getTemperature().getName(), TextJustification.MiddleLeft);
        new ControlText(contents, new Area(0.0f, y += th, w1, th), "Moist. : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), Binnie.Language.translate((Object)treeSpecies.getMoisture()), TextJustification.MiddleLeft);
        new ControlText(contents, new Area(0.0f, y += th, w1, th), "pH. : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), Binnie.Language.translate((Object)treeSpecies.getPH()), TextJustification.MiddleLeft);
        new ControlText(contents, new Area(0.0f, y += th, w1, th), "Fertility : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), genome.getFertility() + "x", TextJustification.MiddleLeft);
        float lifespan = (float)genome.getLifespan() * 68.27f / genome.getAgeChance() / 24000.0f;
        new ControlText(contents, new Area(0.0f, y += th, w1, th), "Lifespan : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), "" + String.format("%.2f", Float.valueOf(lifespan)) + " days", TextJustification.MiddleLeft);
        new ControlText(contents, new Area(0.0f, y += th, w1, th), "Nectar : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), genome.getActiveAllele(EnumFlowerChromosome.SAPPINESS.ordinal()).getName(), TextJustification.MiddleLeft);
        y += th;
        int x = w1;
        int tot = 0;
        for (IIndividual vid : BotanyCore.getFlowerRoot().getIndividualTemplates()) {
            if (vid.getGenome().getPrimary() != treeSpecies) continue;
            if (tot > 0 && tot % 3 == 0) {
                x -= 54;
                y += 18;
            }
            ItemStack stack = BotanyCore.getFlowerRoot().getMemberStack((IFlower)vid, EnumFlowerStage.FLOWER.ordinal());
            ControlItemDisplay display = new ControlItemDisplay(contents, x, y);
            display.setItemStack(stack);
            ++tot;
            x += 18;
        }
        int numOfLines = 1 + (tot - 1) / 3;
        new ControlText(contents, new Area(0.0f, y - (numOfLines - 1) * 18, w1, 4 + 18 * numOfLines), "Varieties : ", TextJustification.MiddleRight);
        contents.setSize(new Vector2f(contents.size().x(), y += th));
        scrollable.setScrollableContent(contents);
    }

    public static String tolerated(boolean t) {
        if (t) {
            return "Tolerated";
        }
        return "Not Tolerated";
    }
}

