/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.binniecore;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.IBinnieMod;
import binnie.core.genetics.BreedingSystem;
import binnie.core.machines.inventory.SlotValidator;
import binnie.craftgui.binniecore.ControlChromosome;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventValueChanged;
import binnie.craftgui.minecraft.ControlImage;
import binnie.craftgui.minecraft.ControlPlayerInventory;
import binnie.craftgui.minecraft.ControlSlot;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.StyleSheet;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import binnie.craftgui.resource.minecraft.PaddedTexture;
import binnie.craftgui.resource.minecraft.StandardTexture;
import binnie.extrabees.core.ExtraBeeTexture;
import binnie.extrabees.gui.punnett.ExtraBeeGUITexture;
import binnie.genetics.machine.Analyser;
import cpw.mods.fml.relauncher.Side;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class WindowFieldKit
extends Window {
    private float glassOffsetX = 0.0f;
    private float glassOffsetY = 0.0f;
    private float glassVX = 0.0f;
    private float glassVY = 0.0f;
    private Random glassRand = new Random();
    private Control GlassControl;
    private ControlChromosome chromo;
    private ControlText text;
    private float analyseProgress = 1.0f;
    private boolean isAnalysing = false;
    Map<IChromosomeType, String> info = new HashMap<IChromosomeType, String>();
    ItemStack prev = null;

    public WindowFieldKit(EntityPlayer player, IInventory inventory, Side side) {
        super(280.0f, 230.0f, player, inventory, side);
        if (!this.isServer()) {
            this.stylesheet = new StyleSheetPunnett();
        }
    }

    @Override
    protected IBinnieMod getMod() {
        return BinnieCore.instance;
    }

    @Override
    protected String getName() {
        return "Field Kit";
    }

    @Override
    public void initialize() {
        this.setTitle("Field Kit");
        this.getWindowInventory().createSlot(0, new SlotValidator(null){

            @Override
            public boolean isValid(ItemStack object) {
                return AlleleManager.alleleRegistry.isIndividual(object) || Binnie.Genetics.getConversion(object) != null;
            }

            @Override
            public String getTooltip() {
                return "Individual";
            }
        });
        new ControlPlayerInventory(this);
        Vector2f handGlass = new Vector2f(16.0f, 32.0f);
        this.GlassControl = new ControlImage(this, handGlass.x(), handGlass.y(), new StandardTexture(0, 160, 96, 96, ExtraBeeTexture.GUIPunnett));
        new ControlSlot(this, handGlass.x() + 54.0f, handGlass.y() + 26.0f).create(this.getWindowInventory(), 0);
        this.text = new ControlText(this, new Area(0.0f, 120.0f, this.w(), 24.0f), "", TextJustification.MiddleCenter);
        this.text.setColour(0x222222);
        this.chromo = new ControlChromosome(this, 150.0f, 24.0f);
        this.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                IChromosomeType type = (IChromosomeType)event.getValue();
                if (type != null && WindowFieldKit.this.info.containsKey(type)) {
                    String t = WindowFieldKit.this.info.get(type);
                    WindowFieldKit.this.text.setValue(t);
                } else {
                    WindowFieldKit.this.text.setValue("");
                }
            }
        }.setOrigin(EventHandler.Origin.DirectChild, this.chromo));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.isAnalysing) {
            if (this.isServer()) {
                this.analyseProgress += 0.01f;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74776_a("progress", this.analyseProgress);
                this.getContainer().sendNBTToClient("analyseProgress", nbt);
            }
            if (this.analyseProgress >= 1.0f) {
                this.isAnalysing = false;
                this.analyseProgress = 1.0f;
                if (this.isServer()) {
                    ItemStack stack = this.getWindowInventory().func_70301_a(0);
                    if (stack != null) {
                        if (!AlleleManager.alleleRegistry.isIndividual(stack)) {
                            BreedingSystem system = Binnie.Genetics.getConversionSystem(stack);
                            IIndividual ind = system.getConversion(stack);
                            stack = system.getSpeciesRoot().getMemberStack(ind, system.getDefaultType());
                        }
                        this.getWindowInventory().func_70299_a(0, Analyser.analyse(stack));
                    }
                } else {
                    this.refreshSpecies();
                }
            }
        }
        if (this.isClient()) {
            this.glassVX += this.glassRand.nextFloat() - 0.5f - this.glassOffsetX * 0.2f;
            this.glassVY += this.glassRand.nextFloat() - 0.5f - this.glassOffsetY * 0.2f;
            this.glassOffsetX += this.glassVX;
            this.glassOffsetX *= 1.0f - this.analyseProgress;
            this.glassOffsetY += this.glassVY;
            this.glassOffsetY *= 1.0f - this.analyseProgress;
            this.GlassControl.setOffset(new Vector2f(this.glassOffsetX, this.glassOffsetY));
        }
    }

    private void refreshSpecies() {
        ItemStack item = this.getWindowInventory().func_70301_a(0);
        if (item == null || !AlleleManager.alleleRegistry.isIndividual(item)) {
            return;
        }
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(item);
        if (ind == null) {
            return;
        }
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(item);
        this.chromo.setRoot(root);
        Random rand = new Random();
        this.info.clear();
        for (IChromosomeType type : root.getKaryotype()) {
            if (type == EnumBeeChromosome.HUMIDITY) continue;
            IAllele allele = ind.getGenome().getActiveAllele(type.ordinal());
            ArrayList<String> infos = new ArrayList<String>();
            int i = 0;
            String pref = root.getUID() + ".fieldkit." + type.getName().toLowerCase() + ".";
            while (Binnie.Language.canTranslate(pref + i)) {
                infos.add(Binnie.Language.translate(pref + i));
                ++i;
            }
            String text = Binnie.Genetics.getSystem(root).getAlleleName(type, allele);
            if (!infos.isEmpty()) {
                text = (String)infos.get(rand.nextInt(infos.size()));
            }
            this.info.put(type, text);
            this.chromo.setRoot(root);
        }
    }

    @Override
    public void onWindowInventoryChanged() {
        super.onWindowInventoryChanged();
        ItemStack item = this.getWindowInventory().func_70301_a(0);
        if (item == this.prev) {
            return;
        }
        this.prev = item;
        if (item != null && !Analyser.isAnalysed(item)) {
            this.startAnalysing();
            this.chromo.setRoot(null);
            if (this.damageKit()) {
                return;
            }
        } else if (item != null) {
            this.isAnalysing = false;
            this.analyseProgress = 1.0f;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74776_a("progress", this.analyseProgress);
            this.getContainer().sendNBTToClient("analyseProgress", nbt);
            this.refreshSpecies();
            if (this.damageKit()) {
                return;
            }
        } else {
            this.isAnalysing = false;
            this.analyseProgress = 1.0f;
        }
    }

    private boolean damageKit() {
        return false;
    }

    private void startAnalysing() {
        this.glassVX = 0.0f;
        this.glassVY = 0.0f;
        this.glassOffsetX = 0.0f;
        this.glassOffsetY = 0.0f;
        this.isAnalysing = true;
        this.analyseProgress = 0.0f;
    }

    @Override
    public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound action) {
        super.recieveGuiNBT(side, player, name, action);
        if (side == Side.CLIENT && name.equals("analyseProgress")) {
            this.analyseProgress = action.func_74760_g("progress");
        }
    }

    static class StyleSheetPunnett
    extends StyleSheet {
        public StyleSheetPunnett() {
            this.textures.put(CraftGUITexture.Window, new PaddedTexture(0, 0, 160, 160, 0, ExtraBeeTexture.GUIPunnett, 32, 32, 32, 32));
            this.textures.put(CraftGUITexture.Slot, new StandardTexture(160, 0, 18, 18, 0, ExtraBeeTexture.GUIPunnett));
            this.textures.put(ExtraBeeGUITexture.Chromosome, new StandardTexture(160, 36, 16, 16, 0, ExtraBeeTexture.GUIPunnett));
            this.textures.put(ExtraBeeGUITexture.Chromosome2, new StandardTexture(160, 52, 16, 16, 0, ExtraBeeTexture.GUIPunnett));
        }
    }
}

