/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.storage;

import binnie.core.BinnieCore;
import binnie.core.IBinnieMod;
import binnie.core.machines.Machine;
import binnie.core.machines.storage.CompartmentTab;
import binnie.core.machines.storage.ComponentCompartmentInventory;
import binnie.core.machines.storage.ControlColourSelector;
import binnie.core.machines.transfer.TransferRequest;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.ControlTextEdit;
import binnie.craftgui.controls.page.ControlPage;
import binnie.craftgui.controls.page.ControlPages;
import binnie.craftgui.controls.tab.ControlTab;
import binnie.craftgui.controls.tab.ControlTabBar;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.CraftGUIUtil;
import binnie.craftgui.core.geometry.Position;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.EventTextEdit;
import binnie.craftgui.events.EventValueChanged;
import binnie.craftgui.genetics.machine.WindowMachine;
import binnie.craftgui.minecraft.ControlItemDisplay;
import binnie.craftgui.minecraft.ControlPlayerInventory;
import binnie.craftgui.minecraft.ControlSlot;
import binnie.craftgui.minecraft.ControlTabIcon;
import binnie.craftgui.minecraft.EnumColor;
import binnie.craftgui.minecraft.IWindowAffectsShiftClick;
import binnie.craftgui.minecraft.MinecraftGUI;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.window.Panel;
import cpw.mods.fml.relauncher.Side;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class WindowCompartment
extends WindowMachine
implements IWindowAffectsShiftClick {
    ControlTextEdit tabName;
    ControlItemDisplay tabIcon;
    ControlColourSelector tabColour;
    boolean dueUpdate;
    int currentTab = 0;

    public static Window create(EntityPlayer player, IInventory inventory, Side side) {
        return new WindowCompartment(player, inventory, side);
    }

    public WindowCompartment(EntityPlayer player, IInventory inventory, Side side) {
        super(320, 240, player, inventory, side);
    }

    @Override
    public void initialize() {
        int p;
        this.setTitle(Machine.getMachine(this.getInventory()).getPackage().getDisplayName());
        int x = 16;
        int y = 32;
        ComponentCompartmentInventory inv = Machine.getMachine(this.getInventory()).getInterface(ComponentCompartmentInventory.class);
        int i = 0;
        int pageWidth = 16 + 18 * inv.getPageSize() / 5;
        final ControlTabBar<Integer> tab = new ControlTabBar<Integer>((IWidget)this, (float)x, (float)y, 24.0f, 106.0f, Position.Left){

            @Override
            public ControlTab<Integer> createTab(float x, float y, float w, float h, Integer value) {
                return new ControlTabIcon<Integer>((ControlTabBar)this, x, y, w, h, value){

                    @Override
                    public ItemStack getItemStack() {
                        return WindowCompartment.this.getTab((Integer)this.value).getIcon();
                    }

                    @Override
                    public String getName() {
                        return WindowCompartment.this.getTab((Integer)this.value).getName();
                    }

                    @Override
                    public int getOutlineColour() {
                        return WindowCompartment.this.getTab((Integer)this.value).getColor().getColour();
                    }

                    @Override
                    public boolean hasOutline() {
                        return true;
                    }
                };
            }
        };
        Integer[] tabs1 = new Integer[]{};
        Integer[] tabs2 = new Integer[]{};
        if (inv.getTabNumber() == 4) {
            tabs1 = new Integer[]{0, 1, 2, 3};
        }
        if (inv.getTabNumber() == 6) {
            tabs1 = new Integer[]{0, 1, 2};
            tabs2 = new Integer[]{3, 4, 5};
        }
        if (inv.getTabNumber() == 8) {
            tabs1 = new Integer[]{0, 1, 2, 3};
            tabs2 = new Integer[]{4, 5, 6, 7};
        }
        tab.setValues(Arrays.asList(tabs1));
        tab.setValue(0);
        tab.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                NBTTagCompound nbt = new NBTTagCompound();
                int i = (Integer)event.getValue();
                nbt.func_74774_a("i", (byte)i);
                ((Window)Window.get(tab)).sendClientAction("tab-change", nbt);
                WindowCompartment.this.currentTab = i;
            }
        }.setOrigin(EventHandler.Origin.DirectChild, tab));
        ControlPages pages = new ControlPages(this, x += 24, y, pageWidth, 106.0f);
        ControlPage[] page = new ControlPage[inv.getTabNumber()];
        for (p = 0; p < inv.getTabNumber(); ++p) {
            page[p] = new ControlPage<Integer>(pages, 0.0f, 0.0f, pages.w(), pages.h(), p);
            pages.addChild(page[p]);
        }
        CraftGUIUtil.linkWidgets(tab, pages);
        for (p = 0; p < inv.getTabNumber(); ++p) {
            ControlPage thisPage = page[p];
            new Panel(thisPage, 0.0f, 0.0f, thisPage.w(), thisPage.h(), MinecraftGUI.PanelType.Black);
            for (int dy = 0; dy < 5; ++dy) {
                for (int dx = 0; dx < inv.getPageSize() / 5; ++dx) {
                    int ix = dx * 18;
                    int iy = dy * 18;
                    new ControlSlot(thisPage, 8 + ix, 8 + iy).create(this.getInventory(), i++);
                }
            }
        }
        ControlPlayerInventory invent = new ControlPlayerInventory(this);
        x += pageWidth;
        if (tabs2.length > 0) {
            ControlTabBar<Integer> tab2 = new ControlTabBar<Integer>((IWidget)this, (float)x, (float)y, 24.0f, 106.0f, Position.Right){

                @Override
                public ControlTab<Integer> createTab(float x, float y, float w, float h, Integer value) {
                    return new ControlTabIcon<Integer>((ControlTabBar)this, x, y, w, h, value){

                        @Override
                        public ItemStack getItemStack() {
                            return WindowCompartment.this.getTab((Integer)this.value).getIcon();
                        }

                        @Override
                        public String getName() {
                            return WindowCompartment.this.getTab((Integer)this.value).getName();
                        }

                        @Override
                        public int getOutlineColour() {
                            return WindowCompartment.this.getTab((Integer)this.value).getColor().getColour();
                        }

                        @Override
                        public boolean hasOutline() {
                            return true;
                        }
                    };
                }
            };
            tab2.setValues(Arrays.asList(tabs2));
            tab2.setValue(0);
            tab2.addEventHandler(new EventValueChanged.Handler(){

                @Override
                public void onEvent(EventValueChanged event) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    int i = (Integer)event.getValue();
                    nbt.func_74774_a("i", (byte)i);
                    ((Window)Window.get(tab)).sendClientAction("tab-change", nbt);
                    WindowCompartment.this.currentTab = i;
                }
            }.setOrigin(EventHandler.Origin.DirectChild, tab2));
            CraftGUIUtil.linkWidgets(tab2, pages);
            x += 24;
        }
        int tabX = x += 16;
        int tabY = y + 20;
        if (x > 230) {
            float width = pageWidth + 24 + (tabs2.length == 0 ? 0 : 24);
            float off = (this.w() - width) / 2.0f - 16.0f;
            pages.setPosition(pages.getPosition().add(new Vector2f(off, 0.0f)));
            for (IWidget w : this.getWidgets()) {
                if (!(w instanceof ControlTabBar)) continue;
                w.setPosition(w.getPosition().add(new Vector2f(off, 0.0f)));
            }
            invent.setPosition(new Vector2f(16.0f, invent.y()));
            tabX = 194;
            tabY = 152;
        }
        Panel panel = new Panel(this, tabX, tabY, 112.0f, 76.0f, MinecraftGUI.PanelType.Gray);
        if ((x += 128) < 320) {
            this.setSize(new Vector2f(x, this.h()));
        }
        int y2 = 4;
        new ControlText((IWidget)panel, new Vector2f(4.0f, y2), "Tab Name:");
        this.tabName = new ControlTextEdit(panel, 4.0f, y2 += 12, 104.0f, 12.0f);
        this.tabName.addSelfEventHandler((EventHandler)new EventTextEdit.Handler(){

            @Override
            public void onEvent(EventTextEdit event) {
                CompartmentTab tab = WindowCompartment.this.getCurrentTab();
                tab.setName((String)event.getValue());
                NBTTagCompound nbt = new NBTTagCompound();
                tab.writeToNBT(nbt);
                WindowCompartment.this.sendClientAction("comp-change-tab", nbt);
            }
        });
        new ControlText((IWidget)panel, new Vector2f(4.0f, y2 += 20), "Tab Icon: ");
        this.tabIcon = new ControlItemDisplay(panel, 58.0f, y2 - 4);
        this.tabIcon.setItemStack(new ItemStack(Items.field_151121_aF));
        this.tabIcon.addAttribute(Attribute.MouseOver);
        this.tabIcon.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                if (WindowCompartment.this.getHeldItemStack() == null) {
                    return;
                }
                CompartmentTab tab = WindowCompartment.this.getCurrentTab();
                ItemStack stack = WindowCompartment.this.getHeldItemStack().func_77946_l();
                stack.field_77994_a = 1;
                tab.setIcon(stack);
                NBTTagCompound nbt = new NBTTagCompound();
                tab.writeToNBT(nbt);
                WindowCompartment.this.sendClientAction("comp-change-tab", nbt);
            }
        });
        this.tabColour = new ControlColourSelector(panel, 82.0f, y2 - 4, 16.0f, 16.0f, EnumColor.White);
        this.tabIcon.addHelp("Icon for current Tab");
        this.tabIcon.addHelp("Click here with an item to change");
        new ControlText((IWidget)panel, new Vector2f(4.0f, y2 += 20), "Colour: ");
        int cw = 8;
        Panel panelColour = new Panel(panel, 40.0f, y2 - 4, cw * 8 + 2, cw * 2 + 1, MinecraftGUI.PanelType.Gray);
        for (int cc = 0; cc < 16; ++cc) {
            final ControlColourSelector color = new ControlColourSelector(panelColour, 1 + cw * (cc % 8), 1 + cw * (cc / 8), cw, cw, EnumColor.values()[cc]);
            color.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

                @Override
                public void onEvent(EventMouse.Down event) {
                    CompartmentTab tab = WindowCompartment.this.getCurrentTab();
                    tab.setColor(color.getValue());
                    NBTTagCompound nbt = new NBTTagCompound();
                    tab.writeToNBT(nbt);
                    WindowCompartment.this.sendClientAction("comp-change-tab", nbt);
                }
            });
        }
        y2 += 20;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateTabs();
    }

    public void updateTabs() {
        this.tabName.setValue(this.getCurrentTab().getName());
        this.tabIcon.setItemStack(this.getCurrentTab().getIcon());
        this.tabColour.setValue(this.getCurrentTab().getColor());
    }

    @Override
    public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound action) {
        super.recieveGuiNBT(side, player, name, action);
        if (name.equals("tab-change")) {
            this.currentTab = action.func_74771_c("i");
        }
    }

    @Override
    public String getTitle() {
        return "Compartment";
    }

    @Override
    protected IBinnieMod getMod() {
        return BinnieCore.instance;
    }

    @Override
    protected String getName() {
        return "compartment";
    }

    @Override
    public void alterRequest(TransferRequest request) {
        if (request.getDestination() == this.getInventory()) {
            ComponentCompartmentInventory inv = Machine.getMachine(this.getInventory()).getInterface(ComponentCompartmentInventory.class);
            request.setTargetSlots(inv.getSlotsForTab(this.currentTab));
        }
    }

    public CompartmentTab getTab(int i) {
        return Machine.getInterface(ComponentCompartmentInventory.class, this.getInventory()).getTab(i);
    }

    public CompartmentTab getCurrentTab() {
        return this.getTab(this.currentTab);
    }
}

