/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.component.IBuildcraft;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.power.PowerSystem;
import binnie.core.machines.power.ProcessInfo;
import binnie.core.triggers.BinnieAction;
import binnie.core.triggers.TriggerData;
import binnie.core.triggers.TriggerWorking;
import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IActionReceptor;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ComponentProcessIndefinate
extends MachineComponent
implements IProcess,
IBuildcraft.ActionProvider,
IBuildcraft.TriggerProvider,
IActionReceptor,
INetwork.TilePacketSync {
    protected float energyPerTick = 0.1f;
    private boolean inProgress;
    float actionPauseProcess = 0.0f;
    float actionCancelTask = 0.0f;
    int clientEnergyPerSecond = 0;
    int clientInProgress;

    @Override
    public void syncFromNBT(NBTTagCompound nbt) {
        this.inProgress = nbt.func_74767_n("progress");
    }

    @Override
    public void syncToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("progress", this.inProgress);
    }

    public ComponentProcessIndefinate(IMachine machine, float energyPerTick) {
        super(machine);
        this.energyPerTick = energyPerTick;
    }

    protected final IPoweredMachine getPower() {
        return this.getMachine().getInterface(IPoweredMachine.class);
    }

    @Override
    public float getEnergyPerTick() {
        return this.energyPerTick;
    }

    @Override
    public void onUpdate() {
        float energyAvailable = (float)this.getPower().getInterface().useEnergy(PowerSystem.MJ, this.getEnergyPerTick(), false);
        if (this.canWork() == null) {
            if (!this.isInProgress() && this.canProgress() == null) {
                this.onStartTask();
            } else if (this.canProgress() == null) {
                this.progressTick();
                this.onTickTask();
            }
        } else if (this.isInProgress()) {
            this.onCancelTask();
        }
        if (this.actionPauseProcess > 0.0f) {
            this.actionPauseProcess -= 1.0f;
        }
        if (this.actionCancelTask > 0.0f) {
            this.actionCancelTask -= 1.0f;
        }
        super.onUpdate();
        if (this.inProgress != this.inProgress()) {
            this.inProgress = this.inProgress();
            this.getUtil().refreshBlock();
        }
    }

    protected void progressTick() {
        this.getPower().getInterface().useEnergy(PowerSystem.MJ, this.getEnergyPerTick(), true);
    }

    @Override
    public ErrorState canWork() {
        return this.actionCancelTask == 0.0f ? null : new ErrorState("Task Cancelled", "Cancelled by Buildcraft Gate");
    }

    @Override
    public ErrorState canProgress() {
        if (this.actionPauseProcess != 0.0f) {
            return new ErrorState("Process Paused", "Paused by Buildcraft Gate");
        }
        return this.getPower().getInterface().getEnergy(PowerSystem.MJ) < (double)this.getEnergyPerTick() ? new ErrorState.InsufficientPower() : null;
    }

    @Override
    public final boolean isInProgress() {
        return this.inProgress;
    }

    protected abstract boolean inProgress();

    protected void onCancelTask() {
    }

    protected void onStartTask() {
    }

    protected void onTickTask() {
    }

    @Override
    public String getTooltip() {
        return "Processing";
    }

    public final void actionActivated(IStatement action, IStatementParameter[] parameters) {
        if (action == BinnieAction.actionCancelTask) {
            this.actionCancelTask = 20.0f;
            this.onCancelTask();
        } else if (action == BinnieAction.actionPauseProcess) {
            this.actionPauseProcess = 20.0f;
        }
    }

    @Override
    public void getTriggers(List<TriggerData> triggers) {
        triggers.add(TriggerWorking.canWork(this));
        triggers.add(TriggerWorking.cannotWork(this));
        triggers.add(TriggerWorking.isWorking(this));
        triggers.add(TriggerWorking.isNotWorking(this));
    }

    @Override
    public void getActions(List<IActionExternal> actions) {
        actions.add(BinnieAction.actionPauseProcess);
        actions.add(BinnieAction.actionCancelTask);
    }

    @Override
    public final ProcessInfo getInfo() {
        return new ProcessInfo(this);
    }
}

