/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.machines.IMachine;
import binnie.core.machines.power.ComponentProcessIndefinate;
import binnie.core.machines.power.IProcessTimed;
import net.minecraft.nbt.NBTTagCompound;

public class ComponentProcess
extends ComponentProcessIndefinate
implements IProcessTimed {
    float progressAmount = 0.0f;
    int processLength;
    int processEnergy;

    public ComponentProcess(IMachine machine, int mjCost, int timePeriod) {
        super(machine, 0.0f);
        this.processLength = timePeriod;
        this.processEnergy = mjCost;
    }

    @Override
    public float getEnergyPerTick() {
        return (float)this.getProcessEnergy() / (float)this.getProcessLength();
    }

    @Override
    public float getProgressPerTick() {
        return 100.0f / (float)this.getProcessLength();
    }

    @Override
    protected void onStartTask() {
        this.progressAmount += 0.01f;
    }

    @Override
    protected void onCancelTask() {
        this.progressAmount = 0.0f;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.progressAmount >= 100.0f) {
            this.onFinishTask();
            this.progressAmount = 0.0f;
        }
    }

    public void alterProgress(float f) {
        this.progressAmount += f;
    }

    public void setProgress(float f) {
        this.progressAmount = f;
    }

    @Override
    protected void progressTick() {
        super.progressTick();
        this.alterProgress(this.getProgressPerTick());
    }

    @Override
    public boolean inProgress() {
        return this.progressAmount > 0.0f;
    }

    @Override
    public float getProgress() {
        return this.progressAmount;
    }

    protected void onFinishTask() {
    }

    @Override
    public int getProcessLength() {
        return this.processLength;
    }

    @Override
    public int getProcessEnergy() {
        return this.processEnergy;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.progressAmount = nbt.func_74760_g("progress");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74776_a("progress", this.progressAmount);
    }
}

