/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import java.util.EnumSet;
import net.minecraftforge.common.util.ForgeDirection;

public enum MachineSide {
    TypeTop,
    TypeBottom,
    TypeSides;

    public static EnumSet<MachineSide> All;
    public static EnumSet<MachineSide> TopAndBottom;
    public static EnumSet<MachineSide> None;
    public static EnumSet<MachineSide> Top;
    public static EnumSet<MachineSide> Bottom;
    public static EnumSet<MachineSide> Sides;

    public static boolean contains(EnumSet<MachineSide> sides, ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return sides.contains((Object)TypeBottom);
            }
            case EAST: 
            case NORTH: 
            case SOUTH: 
            case WEST: {
                return sides.contains((Object)TypeSides);
            }
            case UP: {
                return sides.contains((Object)TypeTop);
            }
        }
        return false;
    }

    public static String asString(EnumSet<MachineSide> sides) {
        if (sides.containsAll(All)) {
            return "Any";
        }
        if (sides.isEmpty()) {
            return "None";
        }
        String text = "";
        int i = 0;
        for (MachineSide side : sides) {
            text = text + side.getName();
            if (++i >= sides.size()) continue;
            text = text + ", ";
        }
        return text;
    }

    private String getName() {
        switch (this) {
            case TypeBottom: {
                return "Bottom";
            }
            case TypeSides: {
                return "Sides";
            }
            case TypeTop: {
                return "Top";
            }
        }
        return "None";
    }

    static {
        All = EnumSet.allOf(MachineSide.class);
        TopAndBottom = EnumSet.of(TypeTop, TypeBottom);
        None = EnumSet.noneOf(MachineSide.class);
        Top = EnumSet.of(TypeTop);
        Bottom = EnumSet.of(TypeBottom);
        Sides = EnumSet.of(TypeSides);
    }
}

