/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.inventory.IChargedSlots;
import binnie.core.machines.network.INetwork;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class ComponentChargedSlots
extends MachineComponent
implements INetwork.GuiNBT,
IChargedSlots {
    Map<Integer, Float> charges = new HashMap<Integer, Float>();

    public ComponentChargedSlots(Machine machine) {
        super(machine);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
    }

    public void addCharge(int slot) {
        this.charges.put(slot, Float.valueOf(0.0f));
    }

    @Override
    public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound nbt) {
        if (name.equals("slot-charges")) {
            for (int i : this.charges.keySet()) {
                this.charges.put(i, Float.valueOf((float)nbt.func_74765_d("" + i) / 100.0f));
            }
        }
    }

    @Override
    public void sendGuiNBT(Map<String, NBTTagCompound> nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        for (int i : this.charges.keySet()) {
            tag.func_74777_a("" + i, (short)(this.charges.get(i).floatValue() * 100.0f));
        }
        nbt.put("slot-charges", tag);
    }

    @Override
    public float getCharge(int slot) {
        return this.charges.containsKey(slot) ? this.charges.get(slot).floatValue() : 0.0f;
    }

    @Override
    public void setCharge(int slot, float charge) {
        if (charge > 1.0f) {
            charge = 1.0f;
        }
        if (charge < 0.0f) {
            charge = 0.0f;
        }
        if (this.charges.containsKey(slot)) {
            this.charges.put(slot, Float.valueOf(charge));
        }
    }

    @Override
    public void onUpdate() {
        for (int slot : this.charges.keySet()) {
            if (!(this.getCharge(slot) <= 0.0f) || this.getUtil().decreaseStack(slot, 1) == null) continue;
            this.setCharge(slot, 1.0f);
        }
    }

    @Override
    public void alterCharge(int slot, float charge) {
        this.setCharge(slot, this.getCharge(slot) + charge);
    }
}

