/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.MachineUtil;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IInteraction;
import binnie.core.machines.component.IRender;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ITankMachine;
import binnie.core.network.BinnieCorePacketID;
import binnie.core.network.INetworkedEntity;
import binnie.core.network.packet.MessageTileNBT;
import binnie.core.network.packet.PacketPayload;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import forestry.api.core.INBTTagable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Machine
implements INetworkedEntity,
INBTTagable,
INetwork.TilePacketSync,
IMachine,
INetwork.GuiNBT {
    MachinePackage machinePackage;
    Map<Class, List<MachineComponent>> componentInterfaceMap = new LinkedHashMap<Class, List<MachineComponent>>();
    Map<Class<? extends MachineComponent>, MachineComponent> componentMap = new LinkedHashMap<Class<? extends MachineComponent>, MachineComponent>();
    TileEntity tile;
    private boolean queuedInventoryUpdate = false;
    int nextProgressBarID = 0;
    GameProfile owner = null;

    public Machine(MachinePackage pack, TileEntity tile) {
        this.tile = tile;
        pack.createMachine(this);
        this.machinePackage = pack;
    }

    @Override
    public void addComponent(MachineComponent component) {
        if (component == null) {
            throw new NullPointerException("Can't have a null machine component!");
        }
        component.setMachine(this);
        this.componentMap.put(component.getClass(), component);
        for (Class inter : component.getComponentInterfaces()) {
            if (!this.componentInterfaceMap.containsKey(inter)) {
                this.componentInterfaceMap.put(inter, new ArrayList());
            }
            this.componentInterfaceMap.get(inter).add(component);
        }
    }

    public Collection<MachineComponent> getComponents() {
        return this.componentMap.values();
    }

    public <T extends MachineComponent> T getComponent(Class<T> componentClass) {
        return (T)(this.hasComponent(componentClass) ? (MachineComponent)componentClass.cast(this.componentMap.get(componentClass)) : null);
    }

    @Override
    public <T> T getInterface(Class<T> interfaceClass) {
        if (this.hasInterface(interfaceClass)) {
            return (T)this.getInterfaces((Class)interfaceClass).get(0);
        }
        if (interfaceClass.isInstance(this.getPackage())) {
            return interfaceClass.cast(this.getPackage());
        }
        for (MachineComponent component : this.getComponents()) {
            if (!interfaceClass.isInstance(component)) continue;
            return interfaceClass.cast(component);
        }
        return null;
    }

    public <T> List<T> getInterfaces(Class<T> interfaceClass) {
        ArrayList<T> interfaces = new ArrayList<T>();
        if (!this.hasInterface(interfaceClass)) {
            return interfaces;
        }
        for (MachineComponent component : this.componentInterfaceMap.get(interfaceClass)) {
            interfaces.add(interfaceClass.cast(component));
        }
        return interfaces;
    }

    public boolean hasInterface(Class<?> interfaceClass) {
        return this.componentInterfaceMap.containsKey(interfaceClass);
    }

    public boolean hasComponent(Class<? extends MachineComponent> componentClass) {
        return this.componentMap.containsKey(componentClass);
    }

    @Override
    public TileEntity getTileEntity() {
        return this.tile;
    }

    public void sendPacket() {
        if (!BinnieCore.proxy.isSimulating(this.getTileEntity().func_145831_w())) {
            return;
        }
        BinnieCore.proxy.sendNetworkEntityPacket((INetworkedEntity)this.getTileEntity());
    }

    public Side getSide() {
        return BinnieCore.proxy.isSimulating(this.getTileEntity().func_145831_w()) ? Side.SERVER : Side.CLIENT;
    }

    @Override
    public void writeToPacket(PacketPayload payload) {
        for (MachineComponent component : this.getComponents()) {
            if (!(component instanceof INetworkedEntity)) continue;
            ((INetworkedEntity)((Object)component)).writeToPacket(payload);
        }
    }

    @Override
    public void readFromPacket(PacketPayload payload) {
        for (MachineComponent component : this.getComponents()) {
            if (!(component instanceof INetworkedEntity)) continue;
            ((INetworkedEntity)((Object)component)).readFromPacket(payload);
        }
    }

    public void onRightClick(World world, EntityPlayer player, int x, int y, int z) {
        for (IInteraction.RightClick component : this.getInterfaces(IInteraction.RightClick.class)) {
            component.onRightClick(world, player, x, y, z);
        }
    }

    @Override
    public void markDirty() {
        this.queuedInventoryUpdate = true;
    }

    public void onUpdate() {
        if (BinnieCore.proxy.isSimulating(this.getWorld())) {
            for (MachineComponent component : this.getComponents()) {
                component.onUpdate();
            }
            if (this.queuedInventoryUpdate) {
                for (MachineComponent component : this.getComponents()) {
                    component.onInventoryUpdate();
                }
                this.queuedInventoryUpdate = false;
            }
        } else {
            for (IRender.DisplayTick renders : this.getInterfaces(IRender.DisplayTick.class)) {
                renders.onDisplayTick(this.getWorld(), this.getTileEntity().field_145851_c, this.getTileEntity().field_145848_d, this.getTileEntity().field_145849_e, this.getWorld().field_73012_v);
            }
        }
    }

    public IInventory getInventory() {
        return this.getInterface(IInventory.class);
    }

    public ITankMachine getTankContainer() {
        return this.getInterface(ITankMachine.class);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        for (MachineComponent component : this.getComponents()) {
            component.readFromNBT(nbttagcompound);
        }
        this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("owner"));
        this.markDirty();
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        for (MachineComponent component : this.getComponents()) {
            component.writeToNBT(nbttagcompound);
        }
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            nbttagcompound.func_74782_a("owner", (NBTBase)nbt);
        }
    }

    @Override
    public MachinePackage getPackage() {
        return this.machinePackage;
    }

    public static IMachine getMachine(Object inventory) {
        if (inventory != null && inventory instanceof IMachine) {
            return (IMachine)inventory;
        }
        if (inventory != null && inventory instanceof TileEntityMachine) {
            return ((TileEntityMachine)inventory).getMachine();
        }
        if (inventory != null && inventory instanceof MachineComponent) {
            return ((MachineComponent)inventory).getMachine();
        }
        return null;
    }

    public static <T> T getInterface(Class<T> interfac, Object inventory) {
        IMachine machine = Machine.getMachine(inventory);
        if (machine != null) {
            return machine.getInterface(interfac);
        }
        if (interfac.isInstance(inventory)) {
            return interfac.cast(inventory);
        }
        return null;
    }

    @Override
    public MachineUtil getMachineUtil() {
        return new MachineUtil(this);
    }

    @Override
    public World getWorld() {
        return this.getTileEntity().func_145831_w();
    }

    public void onBlockDestroy() {
        for (MachineComponent component : this.getComponents()) {
            component.onDestruction();
        }
    }

    public int getUniqueProgressBarID() {
        return this.nextProgressBarID++;
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(GameProfile owner) {
        this.owner = owner;
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.syncToNBT(nbt);
        if (nbt.func_82582_d()) {
            return null;
        }
        return BinnieCore.instance.getNetworkWrapper().getPacketFrom((IMessage)new MessageTileNBT(BinnieCorePacketID.TileDescriptionSync.ordinal(), this.getTileEntity(), nbt).GetMessage());
    }

    @Override
    public void syncToNBT(NBTTagCompound nbt) {
        for (INetwork.TilePacketSync comp : this.getInterfaces(INetwork.TilePacketSync.class)) {
            comp.syncToNBT(nbt);
        }
    }

    @Override
    public void syncFromNBT(NBTTagCompound nbt) {
        for (INetwork.TilePacketSync comp : this.getInterfaces(INetwork.TilePacketSync.class)) {
            comp.syncFromNBT(nbt);
        }
    }

    @Override
    public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound nbt) {
        for (INetwork.RecieveGuiNBT recieve : this.getInterfaces(INetwork.RecieveGuiNBT.class)) {
            recieve.recieveGuiNBT(side, player, name, nbt);
        }
    }

    @Override
    public void sendGuiNBT(Map<String, NBTTagCompound> nbt) {
        for (INetwork.SendGuiNBT recieve : this.getInterfaces(INetwork.SendGuiNBT.class)) {
            recieve.sendGuiNBT(nbt);
        }
    }
}

