/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.IBlockMachine;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineGroup;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IRender;
import binnie.core.machines.power.PowerSystem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMachine
extends BlockContainer
implements IBlockMachine {
    MachineGroup group;

    public BlockMachine(MachineGroup group, String blockName) {
        super(Material.field_151573_f);
        this.group = group;
        this.func_149711_c(1.5f);
        this.func_149663_c(blockName);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (MachinePackage pack : this.group.getPackages()) {
            if (!pack.isActive()) continue;
            if (pack.powered) {
                for (PowerSystem system : PowerSystem.values()) {
                    if (!system.active()) continue;
                    ItemStack stack = new ItemStack((Block)this, 1, pack.getMetadata().intValue());
                    stack = system.saveTo(stack);
                    itemList.add(stack);
                }
                continue;
            }
            itemList.add(new ItemStack((Block)this, 1, pack.getMetadata().intValue()));
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return !this.group.customRenderer;
    }

    public int func_149645_b() {
        return Binnie.Machine.getMachineRenderID();
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (this.group.getPackage(metadata) == null) {
            return null;
        }
        return this.group.getPackage(metadata).createTileEntity();
    }

    @Override
    public MachinePackage getPackage(int meta) {
        return this.group.getPackage(meta);
    }

    @Override
    public String getMachineName(int meta) {
        return this.getPackage(meta) == null ? "Unnamed Machine" : this.getPackage(meta).getDisplayName();
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    public TileEntity func_149915_a(World var1, int meta) {
        return this.createTileEntity(var1, meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (!BinnieCore.proxy.isSimulating(world)) {
            return true;
        }
        if (player.func_70093_af()) {
            return true;
        }
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity instanceof TileEntityMachine) {
            ((TileEntityMachine)entity).getMachine().onRightClick(world, player, x, y, z);
        }
        return true;
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        super.func_149689_a(world, i, j, k, entityliving, stack);
        if (!BinnieCore.proxy.isSimulating(world)) {
            return;
        }
        IMachine machine = Machine.getMachine(world.func_147438_o(i, j, k));
        if (machine == null) {
            return;
        }
        if (entityliving instanceof EntityPlayer) {
            machine.setOwner(((EntityPlayer)entityliving).func_146103_bH());
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity instanceof TileEntityMachine && ((TileEntityMachine)entity).getMachine().hasInterface(IMachineTexturedFaces.class)) {
            return ((TileEntityMachine)entity).getMachine().getInterface(IMachineTexturedFaces.class).getIcon(side);
        }
        return Blocks.field_150346_d.func_149691_a(0, 0);
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity tileentity = world.func_147438_o(x, y, z);
        if (!(tileentity instanceof TileEntityMachine)) {
            return;
        }
        TileEntityMachine entity = (TileEntityMachine)tileentity;
        if (entity != null) {
            entity.onBlockDestroy();
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        IMachine machine = Machine.getMachine(world.func_147438_o(x, y, z));
        if (machine != null) {
            for (IRender.RandomDisplayTick renders : machine.getInterfaces(IRender.RandomDisplayTick.class)) {
                renders.onRandomDisplayTick(world, x, y, z, rand);
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (BinnieCore.proxy.isSimulating(world) && this.canHarvestBlock(player, world.func_72805_g(x, y, z)) && !player.field_71075_bZ.field_75098_d) {
            int metadata = world.func_72805_g(x, y, z);
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, this.func_149692_a(metadata));
            this.func_149642_a(world, x, y, z, stack);
        }
        return world.func_147468_f(x, y, z);
    }

    public static interface IMachineTexturedFaces {
        public IIcon getIcon(int var1);
    }
}

