/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.Binnie;
import binnie.core.BaseManager;
import binnie.core.BinnieCore;
import binnie.core.liquid.BinnieFluid;
import binnie.core.liquid.FluidContainer;
import binnie.core.liquid.IFluidType;
import binnie.core.liquid.ItemFluidContainer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class LiquidManager
extends BaseManager {
    Map<String, IFluidType> fluids = new LinkedHashMap<String, IFluidType>();

    public Collection<IFluidType> getFluidTypes() {
        return this.fluids.values();
    }

    public void createLiquids(IFluidType[] liquids, int startID) {
        for (IFluidType liquid : liquids) {
            BinnieFluid fluid;
            if ((fluid = this.createLiquid(liquid, startID++)) != null) continue;
            throw new RuntimeException("Liquid registered incorrectly - " + liquid.getIdentifier());
        }
    }

    public BinnieFluid createLiquid(IFluidType fluid, int id) {
        this.fluids.put(fluid.getIdentifier().toLowerCase(), fluid);
        BinnieFluid bFluid = new BinnieFluid(fluid);
        FluidRegistry.registerFluid((Fluid)bFluid);
        ItemFluidContainer.registerFluid(fluid, id);
        return bFluid;
    }

    public FluidStack getLiquidStack(String name, int amount) {
        return FluidRegistry.getFluidStack((String)name.toLowerCase(), (int)amount);
    }

    public void reloadIcons(IIconRegister register) {
        for (IFluidType type : this.fluids.values()) {
            Fluid fluid = this.getLiquidStack(type.getIdentifier(), 1).getFluid();
            type.registerIcon(register);
            if (fluid == null) {
                throw new RuntimeException("[Binnie] Liquid not registered properly - " + type.getIdentifier());
            }
            fluid.setIcons(type.getIcon());
        }
    }

    @Override
    public void init() {
        for (FluidContainer container : FluidContainer.values()) {
            container.name = Binnie.Language.item(BinnieCore.instance, "container." + container.name().toLowerCase());
        }
    }

    @Override
    public void postInit() {
        for (IFluidType fluid : this.fluids.values()) {
            for (FluidContainer container : FluidContainer.values()) {
                if (!container.isActive() || !fluid.canPlaceIn(container)) continue;
                container.registerContainerData(fluid);
            }
        }
    }

    public IFluidType getFluidType(String liquid) {
        return this.fluids.get(liquid.toLowerCase());
    }
}

