/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.Binnie;
import binnie.core.liquid.BinnieFluid;
import binnie.core.liquid.FluidContainer;
import binnie.core.liquid.IFluidType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;

public class ItemFluidContainer
extends Item {
    FluidContainer container;
    public static int LiquidExtraBee = 64;
    public static int LiquidExtraTree = 128;
    public static int LiquidJuice = 256;
    public static int LiquidAlcohol = 384;
    public static int LiquidSpirit = 512;
    public static int LiquidLiqueuer = 640;
    public static int LiquidGenetics = 768;
    public static Map<Integer, String> idToFluid = new HashMap<Integer, String>();
    public static Map<String, Integer> fluidToID = new HashMap<String, Integer>();

    public static void registerFluid(IFluidType fluid, int id) {
        idToFluid.put(id, fluid.getIdentifier().toLowerCase());
        fluidToID.put(fluid.getIdentifier().toLowerCase(), id);
    }

    public ItemFluidContainer(FluidContainer container) {
        this.container = container;
        container.item = this;
        this.field_77777_bU = container.getMaxStackSize();
        this.func_77627_a(true);
        this.func_77655_b("container" + container.name());
        this.func_77637_a(CreativeTabs.field_78035_l);
    }

    private FluidStack getLiquid(ItemStack stack) {
        String liquid = idToFluid.get(stack.func_77960_j());
        return liquid == null ? null : Binnie.Liquid.getLiquidStack(liquid, 1000);
    }

    public void func_94581_a(IIconRegister register) {
        this.container.updateIcons(register);
    }

    public String func_77653_i(ItemStack itemstack) {
        if (itemstack == null) {
            return "???";
        }
        FluidStack fluid = this.getLiquid(itemstack);
        if (fluid == null) {
            return "Missing Fluid";
        }
        return fluid.getFluid().getLocalizedName(fluid) + " " + this.container.getName();
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (IFluidType liquid : Binnie.Liquid.fluids.values()) {
            if (!liquid.canPlaceIn(this.container) || !liquid.showInCreative(this.container)) continue;
            itemList.add(this.getContainer(liquid));
        }
    }

    public ItemStack getContainer(IFluidType liquid) {
        int id = fluidToID.get(liquid.getIdentifier().toLowerCase());
        ItemStack itemstack = new ItemStack((Item)this, 1, id);
        return itemstack;
    }

    public IIcon getIcon(ItemStack itemstack, int j) {
        if (j > 0) {
            return this.container.getBottleIcon();
        }
        return this.container.getContentsIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack item, int pass) {
        FluidStack fluid = this.getLiquid(item);
        if (fluid == null) {
            return 0xFFFFFF;
        }
        if (pass == 0 && fluid.getFluid() instanceof BinnieFluid) {
            return ((BinnieFluid)fluid.getFluid()).fluidType.getContainerColour();
        }
        return super.func_82790_a(item, pass);
    }

    public boolean func_77623_v() {
        return true;
    }
}

