/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.IBinnieMod;
import binnie.core.liquid.FluidContainer;
import binnie.core.liquid.IFluidType;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidType
implements IFluidType {
    String ident;
    String name;
    IIcon icon;
    IBinnieMod mod;
    String iconPath;
    int containerColour;

    public FluidType(String ident, IBinnieMod mod, String localisation, String iconPath, int containerColour) {
        this.ident = ident;
        this.name = Binnie.Language.liquid(mod, localisation);
        this.mod = mod;
        this.iconPath = iconPath;
        this.containerColour = containerColour;
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public void registerIcon(IIconRegister register) {
        this.icon = BinnieCore.proxy.getIcon(register, this.mod.getModID(), this.iconPath);
    }

    @Override
    public String getName() {
        return Binnie.Language.translate(this.name);
    }

    @Override
    public String getIdentifier() {
        return this.ident;
    }

    @Override
    public FluidStack get(int amount) {
        return FluidRegistry.getFluidStack((String)this.getIdentifier(), (int)amount);
    }

    @Override
    public int getColour() {
        return 0xFFFFFF;
    }

    @Override
    public int getTransparency() {
        return 255;
    }

    @Override
    public boolean canPlaceIn(FluidContainer container) {
        return false;
    }

    @Override
    public boolean showInCreative(FluidContainer container) {
        return false;
    }

    @Override
    public int getContainerColour() {
        return this.containerColour;
    }
}

