/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.genetics.BreedingSystem;
import binnie.core.util.UniqueItemStackSet;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.machines.Lumbermill;
import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAllelePlantType;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class TreeBreedingSystem
extends BreedingSystem {
    public UniqueItemStackSet allFruits = new UniqueItemStackSet();
    public UniqueItemStackSet allWoods = new UniqueItemStackSet();
    public UniqueItemStackSet allPlanks = new UniqueItemStackSet();
    public UniqueItemStackSet discoveredFruits = new UniqueItemStackSet();
    public UniqueItemStackSet discoveredWoods = new UniqueItemStackSet();
    public UniqueItemStackSet discoveredPlanks = new UniqueItemStackSet();

    public TreeBreedingSystem() {
        this.iconUndiscovered = Binnie.Resource.getItemIcon(ExtraTrees.instance, "icon/undiscoveredTree");
        this.iconDiscovered = Binnie.Resource.getItemIcon(ExtraTrees.instance, "icon/discoveredTree");
    }

    @Override
    public float getChance(IMutation mutation, EntityPlayer player, IAllele species1, IAllele species2) {
        IGenome genome0 = this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(species1.getUID()));
        IGenome genome1 = this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(species2.getUID()));
        return ((ITreeMutation)mutation).getChance(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, species1, species2, genome0, genome1);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return Binnie.Genetics.getTreeRoot();
    }

    @Override
    public int getColour() {
        return 53006;
    }

    @Override
    public Class<? extends IBreedingTracker> getTrackerClass() {
        return IArboristTracker.class;
    }

    @Override
    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (chromosome == EnumTreeChromosome.GIRTH) {
            return ((IAlleleInteger)allele).getValue() + "x" + ((IAlleleInteger)allele).getValue();
        }
        if (chromosome == EnumTreeChromosome.PLANT) {
            EnumSet types = ((IAllelePlantType)allele).getPlantTypes();
            return types.isEmpty() ? Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.none") : ((EnumPlantType)types.iterator().next()).toString();
        }
        if (chromosome == EnumTreeChromosome.FRUITS && allele.getUID().contains(".")) {
            IFruitProvider provider = ((IAlleleFruit)allele).getProvider();
            return provider.getProducts().length == 0 ? Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.none") : provider.getProducts()[0].func_82833_r();
        }
        if (chromosome == EnumTreeChromosome.GROWTH) {
            if (allele.getUID().contains("Tropical")) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.growth.tropical");
            }
            if (allele.getUID().contains("Lightlevel")) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.growth.lightlevel");
            }
        }
        return super.getAlleleName(chromosome, allele);
    }

    @Override
    public void onSyncBreedingTracker(IBreedingTracker tracker) {
        this.discoveredFruits.clear();
        this.discoveredWoods.clear();
        for (IAlleleSpecies species : this.getDiscoveredSpecies(tracker)) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(tSpecies.getUID()));
            for (ItemStack wood : tSpecies.getLogStacks()) {
                this.discoveredWoods.add(wood);
            }
            for (ItemStack fruit : genome.getFruitProvider().getProducts()) {
                this.discoveredFruits.add(fruit);
            }
            for (ItemStack wood : this.discoveredWoods) {
            }
        }
    }

    @Override
    public final void calculateArrays() {
        super.calculateArrays();
        for (IAlleleSpecies species : this.allActiveSpecies) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(tSpecies.getUID()));
            for (ItemStack wood : tSpecies.getLogStacks()) {
                this.allWoods.add(wood);
            }
            for (ItemStack fruit : genome.getFruitProvider().getProducts()) {
                this.allFruits.add(fruit);
            }
            for (ItemStack wood : this.allWoods) {
            }
        }
    }

    public Collection<IAlleleSpecies> getTreesThatBearFruit(ItemStack fruit, boolean nei, World world, GameProfile player) {
        Collection<IAlleleSpecies> set = nei ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : set) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(tSpecies.getUID()));
            for (ItemStack fruit2 : genome.getFruitProvider().getProducts()) {
                if (!fruit2.func_77969_a(fruit)) continue;
                found.add(species);
            }
        }
        return found;
    }

    public Collection<IAlleleSpecies> getTreesThatCanBearFruit(ItemStack fruit, boolean nei, World world, GameProfile player) {
        IAlleleTreeSpecies tSpecies;
        Collection<IAlleleSpecies> set = nei ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        HashSet<IFruitFamily> providers = new HashSet<IFruitFamily>();
        for (IAlleleSpecies species : set) {
            tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(tSpecies.getUID()));
            for (ItemStack fruit2 : genome.getFruitProvider().getProducts()) {
                if (!fruit2.func_77969_a(fruit)) continue;
                providers.add(genome.getFruitProvider().getFamily());
            }
        }
        block2: for (IAlleleSpecies species : set) {
            tSpecies = (IAlleleTreeSpecies)species;
            for (IFruitFamily family : providers) {
                if (!tSpecies.getSuitableFruit().contains(family)) continue;
                found.add(species);
                continue block2;
            }
        }
        return found;
    }

    public Collection<IAlleleSpecies> getTreesThatHaveWood(ItemStack fruit, boolean nei, World world, GameProfile player) {
        Collection<IAlleleSpecies> set = nei ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : set) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            for (ItemStack fruit2 : tSpecies.getLogStacks()) {
                if (!fruit2.func_77969_a(fruit)) continue;
                found.add(species);
            }
        }
        return found;
    }

    public Collection<IAlleleSpecies> getTreesThatMakePlanks(ItemStack fruit, boolean nei, World world, GameProfile player) {
        if (fruit == null) {
            return new ArrayList<IAlleleSpecies>();
        }
        Collection<IAlleleSpecies> set = nei ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : set) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            for (ItemStack fruit2 : tSpecies.getLogStacks()) {
                if (Lumbermill.getPlankProduct(fruit2) == null || !fruit.func_77969_a(Lumbermill.getPlankProduct(fruit2))) continue;
                found.add(species);
            }
        }
        return found;
    }

    @Override
    public int getDefaultType() {
        return EnumGermlingType.SAPLING.ordinal();
    }

    @Override
    public boolean isDNAManipulable(ItemStack member) {
        return ((ITreeRoot)this.getSpeciesRoot()).getType(member) == EnumGermlingType.POLLEN;
    }

    @Override
    public IIndividual getConversion(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (Map.Entry entry : AlleleManager.ersatzSaplings.entrySet()) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)((ItemStack)entry.getKey()))) continue;
            return (IIndividual)entry.getValue();
        }
        return null;
    }
}

