/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.genetics.BreedingSystem;
import binnie.extratrees.ExtraTrees;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.api.lepidopterology.ILepidopteristTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class MothBreedingSystem
extends BreedingSystem {
    public MothBreedingSystem() {
        this.iconUndiscovered = Binnie.Resource.getItemIcon(ExtraTrees.instance, "icon/undiscoveredMoth");
        this.iconDiscovered = Binnie.Resource.getItemIcon(ExtraTrees.instance, "icon/discoveredMoth");
    }

    @Override
    public float getChance(IMutation mutation, EntityPlayer player, IAllele species1, IAllele species2) {
        return 0.0f;
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return Binnie.Genetics.getButterflyRoot();
    }

    @Override
    public int getColour() {
        return 62194;
    }

    @Override
    public Class<? extends IBreedingTracker> getTrackerClass() {
        return ILepidopteristTracker.class;
    }

    @Override
    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (chromosome == EnumButterflyChromosome.METABOLISM) {
            int metabolism = ((IAlleleInteger)allele).getValue();
            if (metabolism >= 19) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.metabolism.highest");
            }
            if (metabolism >= 16) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.metabolism.higher");
            }
            if (metabolism >= 13) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.metabolism.high");
            }
            if (metabolism >= 10) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.metabolism.normal");
            }
            if (metabolism >= 7) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.metabolism.slow");
            }
            if (metabolism >= 4) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.metabolism.slower");
            }
            return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.metabolism.slowest");
        }
        if (chromosome == EnumButterflyChromosome.FERTILITY) {
            int metabolism = ((IAlleleInteger)allele).getValue();
            return metabolism + "x";
        }
        return super.getAlleleName(chromosome, allele);
    }

    @Override
    public int getDefaultType() {
        return 0;
    }

    @Override
    public boolean isDNAManipulable(ItemStack member) {
        return ((IButterflyRoot)this.getSpeciesRoot()).getType(member) == EnumFlutterType.SERUM;
    }
}

