/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.botany.api.IFlowerRoot;
import binnie.core.BaseManager;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.Tolerance;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.IButterflyRoot;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GeneticsManager
extends BaseManager {
    public BreedingSystem beeBreedingSystem;
    public BreedingSystem treeBreedingSystem;
    public BreedingSystem mothBreedingSystem;
    public BreedingSystem flowerBreedingSystem;
    private final Map<ISpeciesRoot, BreedingSystem> BREEDING_SYSTEMS = new HashMap<ISpeciesRoot, BreedingSystem>();

    public boolean isSpeciesDiscovered(IAlleleSpecies species, World world, boolean nei) {
        return true;
    }

    public ITreeRoot getTreeRoot() {
        return (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
    }

    public IBeeRoot getBeeRoot() {
        return (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
    }

    public IButterflyRoot getButterflyRoot() {
        return (IButterflyRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies");
    }

    public IFlowerRoot getFlowerRoot() {
        return (IFlowerRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootFlowers");
    }

    public BreedingSystem getSystem(String string) {
        for (BreedingSystem system : this.BREEDING_SYSTEMS.values()) {
            if (!system.getIdent().equals(string)) continue;
            return system;
        }
        return null;
    }

    public BreedingSystem getSystem(ISpeciesRoot root) {
        return this.getSystem(root.getUID());
    }

    public ISpeciesRoot getSpeciesRoot(IAlleleSpecies species) {
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            if (!root.getKaryotype()[0].getAlleleClass().isInstance(species)) continue;
            return root;
        }
        return null;
    }

    public IAllele getToleranceAllele(EnumTolerance tol) {
        return AlleleManager.alleleRegistry.getAllele(Tolerance.values()[tol.ordinal()].getUID());
    }

    public int[] getTolerance(EnumTolerance tol) {
        return Tolerance.values()[tol.ordinal()].getBounds();
    }

    public Collection<BreedingSystem> getActiveSystems() {
        return this.BREEDING_SYSTEMS.values();
    }

    public void registerBreedingSystem(BreedingSystem system) {
        this.BREEDING_SYSTEMS.put(system.getSpeciesRoot(), system);
    }

    public BreedingSystem getConversionSystem(ItemStack stack) {
        for (BreedingSystem system : this.getActiveSystems()) {
            if (system.getConversion(stack) == null) continue;
            return system;
        }
        return null;
    }

    public IIndividual getConversion(ItemStack stack) {
        BreedingSystem system = this.getConversionSystem(stack);
        return system == null ? null : system.getConversion(stack);
    }
}

