/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.Binnie;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;

public class ForestryAllele {

    public static enum BeeSpecies {
        Modest,
        Noble,
        Forest,
        Rural,
        Marshy,
        Sinister,
        Tropical,
        Wintry,
        Merry,
        Austere,
        Imperial,
        Ended,
        Meadows,
        Common,
        Frugal,
        Unweary,
        Diligent,
        Majestic,
        Cultivated,
        Industrious,
        Valiant,
        Secluded,
        Hermitic,
        Spectral,
        Exotic,
        Fiendish;


        public IAlleleBeeSpecies getAllele() {
            return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + this.toString());
        }

        public IAllele[] getTemplate() {
            return Binnie.Genetics.getBeeRoot().getTemplate(this.getAllele().getUID());
        }
    }

    public static enum Growth {
        Tropical;


        public IAllele getAllele() {
            return AlleleManager.alleleRegistry.getAllele("forestry.growth" + this.toString());
        }
    }

    public static enum TreeHeight {
        Smallest,
        Smaller,
        Small,
        Average,
        Large,
        Larger,
        Largest,
        Gigantic;


        public IAllele getAllele() {
            return AlleleManager.alleleRegistry.getAllele("forestry.height" + (this == Average ? "Max10" : this.toString()));
        }
    }

    public static enum Sappiness {
        Lowest,
        Lower,
        Low,
        Average,
        High,
        Higher,
        Highest;


        public IAllele getAllele() {
            return AlleleManager.alleleRegistry.getAllele("forestry.sappiness" + this.toString());
        }
    }

    public static enum Territory {
        Default,
        Large,
        Larger,
        Largest;


        public IAllele getAllele() {
            return AlleleManager.alleleRegistry.getAllele("forestry.territory" + this.toString());
        }
    }

    public static enum Flowering {
        Slowest,
        Slower,
        Slow,
        Average,
        Fast,
        Faster,
        Fastest,
        Maximum;


        public IAllele getAllele() {
            return AlleleManager.alleleRegistry.getAllele("forestry.flowering" + this.toString());
        }
    }

    public static enum Fertility {
        Low,
        Normal,
        High,
        Maximum;


        public IAllele getAllele() {
            return AlleleManager.alleleRegistry.getAllele("forestry.fertility" + this.toString());
        }
    }

    public static enum Speed {
        Slowest,
        Slower,
        Slow,
        Norm,
        Fast,
        Faster,
        Fastest;


        public IAllele getAllele() {
            return AlleleManager.alleleRegistry.getAllele("forestry.speed" + this.toString());
        }
    }

    public static enum Lifespan {
        Shortest,
        Shorter,
        Short,
        Shortened,
        Normal,
        Elongated,
        Long,
        Longer,
        Longest;


        public IAllele getAllele() {
            return AlleleManager.alleleRegistry.getAllele("forestry.lifespan" + this.toString());
        }
    }
}

