/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.Binnie;
import binnie.botany.api.EnumFlowerChromosome;
import binnie.botany.api.EnumFlowerStage;
import binnie.botany.api.IBotanistTracker;
import binnie.botany.api.IFlowerMutation;
import binnie.botany.api.IFlowerRoot;
import binnie.botany.core.BotanyCore;
import binnie.core.BinnieCore;
import binnie.core.genetics.BreedingSystem;
import binnie.extrabees.ExtraBees;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class FlowerBreedingSystem
extends BreedingSystem {
    public FlowerBreedingSystem() {
        this.iconUndiscovered = Binnie.Resource.getItemIcon(ExtraBees.instance, "icon/undiscoveredBee");
        this.iconDiscovered = Binnie.Resource.getItemIcon(ExtraBees.instance, "icon/discoveredBee");
    }

    @Override
    public float getChance(IMutation mutation, EntityPlayer player, IAllele species1, IAllele species2) {
        return ((IFlowerMutation)mutation).getBaseChance();
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return Binnie.Genetics.getFlowerRoot();
    }

    @Override
    public int getColour() {
        return 14563127;
    }

    @Override
    public Class<? extends IBreedingTracker> getTrackerClass() {
        return IBotanistTracker.class;
    }

    @Override
    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (chromosome == EnumFlowerChromosome.FERTILITY) {
            if (allele.getUID().contains("Low")) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.fertility.low");
            }
            if (allele.getUID().contains("Normal")) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.fertility.normal");
            }
            if (allele.getUID().contains("High")) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.fertility.high");
            }
            if (allele.getUID().contains("Maximum")) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.fertility.maximum");
            }
        }
        return super.getAlleleName(chromosome, allele);
    }

    @Override
    public int getDefaultType() {
        return EnumFlowerStage.FLOWER.ordinal();
    }

    @Override
    public boolean isDNAManipulable(ItemStack member) {
        return ((IFlowerRoot)this.getSpeciesRoot()).getType(member) == EnumFlowerStage.POLLEN;
    }

    @Override
    public IIndividual getConversion(ItemStack stack) {
        return BotanyCore.getFlowerRoot().getConversion(stack);
    }
}

