/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.VirtualBeeHousing;
import binnie.extrabees.ExtraBees;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class BeeBreedingSystem
extends BreedingSystem {
    public BeeBreedingSystem() {
        this.iconUndiscovered = Binnie.Resource.getItemIcon(ExtraBees.instance, "icon/undiscoveredBee");
        this.iconDiscovered = Binnie.Resource.getItemIcon(ExtraBees.instance, "icon/discoveredBee");
    }

    @Override
    public float getChance(IMutation mutation, EntityPlayer player, IAllele species1, IAllele species2) {
        return ((IBeeMutation)mutation).getChance((IBeeHousing)new VirtualBeeHousing(player), species1, species2, this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(species1.getUID())), this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(species2.getUID())));
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return Binnie.Genetics.getBeeRoot();
    }

    @Override
    public int getColour() {
        return 16767232;
    }

    @Override
    public Class<? extends IBreedingTracker> getTrackerClass() {
        return IApiaristTracker.class;
    }

    @Override
    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (chromosome == EnumBeeChromosome.FERTILITY) {
            if (allele.getUID().contains("Low")) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.fertility.low");
            }
            if (allele.getUID().contains("Normal")) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.fertility.normal");
            }
            if (allele.getUID().contains("High")) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.fertility.high");
            }
            if (allele.getUID().contains("Maximum")) {
                return Binnie.Language.getAndTranslate(BinnieCore.instance, "allele.fertility.maximum");
            }
        }
        return super.getAlleleName(chromosome, allele);
    }

    @Override
    public int getDefaultType() {
        return EnumBeeType.DRONE.ordinal();
    }

    @Override
    public boolean isDNAManipulable(ItemStack member) {
        return ((IBeeRoot)this.getSpeciesRoot()).getType(member) == EnumBeeType.LARVAE;
    }
}

